/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.FileDataSet;
import org.cassandraunit.dataset.ParseException;
import org.codehaus.mojo.cassandra.AbstractCqlLoadMojo;
import org.codehaus.mojo.cassandra.Utils;

public class StartCassandraMojo
extends AbstractCqlLoadMojo {
    protected int startWaitSeconds;
    private boolean loadAfterFirstStart;
    protected File cuDataSet;
    private boolean cuLoadFailureIgnore;
    private boolean cuLoadAfterFirstStart;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        long timeStamp = System.currentTimeMillis();
        boolean isClean = !this.cassandraDir.isDirectory();
        this.getLog().debug((CharSequence)((isClean ? "First start of Cassandra instance in " : "Re-using existing Cassandra instance in ") + this.cassandraDir.getAbsolutePath()));
        try {
            Utils.startCassandraServer(this.cassandraDir, this.newServiceCommandLine(), this.createEnvironmentVars(), this.getLog());
            if (this.startWaitSeconds >= 0) {
                this.getLog().info((CharSequence)"Waiting for Cassandra to start...");
                boolean started = Utils.waitUntilStarted(this.rpcAddress, this.rpcPort, this.startWaitSeconds, this.getLog());
                if (!started) {
                    Utils.stopCassandraServer(this.rpcAddress, this.rpcPort, this.listenAddress, this.stopPort, this.stopKey, this.getLog());
                    throw new MojoFailureException("Cassandra failed to start within " + this.startWaitSeconds + "s");
                }
            }
            if (isClean && this.loadAfterFirstStart) {
                this.execCqlFile();
            }
            if (isClean && this.cuLoadAfterFirstStart && this.cuDataSet != null && this.cuDataSet.isFile()) {
                this.getLog().info((CharSequence)("Loading CassandraUnit dataSet " + this.cuDataSet + "..."));
                try {
                    DataLoader dataLoader = new DataLoader("cassandraUnitCluster", this.rpcAddress + ":" + this.rpcPort);
                    dataLoader.load((DataSet)new FileDataSet(this.cuDataSet.getAbsolutePath()));
                }
                catch (ParseException e) {
                    if (this.cuLoadFailureIgnore) {
                        this.getLog().error((CharSequence)(e.getMessage() + ". Ignoring as cuLoadFailureIgnore is true"));
                    }
                    throw new MojoExecutionException("Error while loading CassandraUnit dataSet", (Exception)((Object)e));
                }
                this.getLog().info((CharSequence)("Finished " + this.cuDataSet + "."));
            }
            this.getLog().info((CharSequence)("Cassandra started in " + (double)((System.currentTimeMillis() - timeStamp) / 100L) / 10.0 + "s"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }
}

