package org.codehaus.mojo.javacc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on javacc-maven-plugin.<br/> Call <pre>  mvn javacc:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Sep 30 00:27:24 CEST 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:javacc-maven-plugin:2.6", 0 );
        append( sb, "", 0 );

        append( sb, "JavaCC Maven Plugin", 0 );
        append( sb, "Maven 2 Plugin for processing JavaCC grammar files.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "javacc:help", 0 );
            append( sb, "Display help information on javacc-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0javacc:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "javacc".equals( goal ) )
        {
            append( sb, "javacc:javacc", 0 );
            append( sb, "Parses a JavaCC grammar file (*.jj) and transforms it to Java source files. Detailed information about the JavaCC options can be found on the JavaCC website.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "buildParser", 2 );
                append( sb, "A flag that controls whether the parser file (*Parser.java) should be generated or not. If set to false, only the token manager is generated. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "buildTokenManager", 2 );
                append( sb, "A flag that controls whether the token manager file (*TokenManager.java) should be generated or not. Setting this to false can speed up the generation process if only the parser part of the grammar changed. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "cacheTokens", 2 );
                append( sb, "Setting this option to true causes the generated parser to lookahead for extra tokens ahead of time. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "choiceAmbiguityCheck", 2 );
                append( sb, "This is the number of tokens considered in checking choices of the form \'A | B | ...\' for ambiguity. Default value is 2.", 3 );
                append( sb, "", 0 );

                append( sb, "commonTokenAction", 2 );
                append( sb, "When set to true, every call to the token manager\'s method getNextToken() (see the description of the Java Compiler Compiler API) will cause a call to a user-defined method CommonTokenAction() after the token has been scanned in by the token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "debugLookAhead", 2 );
                append( sb, "This is a boolean option whose default value is false. Setting this option to true causes the parser to generate all the tracing information it does when the option debugParser is true, and in addition, also causes it to generated a trace of actions performed during lookahead operation.", 3 );
                append( sb, "", 0 );

                append( sb, "debugParser", 2 );
                append( sb, "This option is used to obtain debugging information from the generated parser. Setting this option to true causes the parser to generate a trace of its actions. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "debugTokenManager", 2 );
                append( sb, "This option is used to obtain debugging information from the generated token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "errorReporting", 2 );
                append( sb, "Setting it to false causes errors due to parse errors to be reported in somewhat less detail. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A set of Ant-like exclusion patterns used to prevent certain files from being processed. By default, this set is empty such that no files are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "forceLaCheck", 2 );
                append( sb, "This option setting controls lookahead ambiguity checking performed by JavaCC. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "grammarEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use for reading the grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreCase", 2 );
                append( sb, "Setting this option to true causes the generated token manager to ignore case in the token specifications and the input files. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A set of Ant-like inclusion patterns used to select files from the source directory for processing. By default, the patterns **/*.jj and **/*.JJ are used to select grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "isStatic", 2 );
                append( sb, "If true, all methods and class variables are specified as static in the generated parser and token manager. This allows only one parser object to be present, but it improves the performance of the parser. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "javaUnicodeEscape", 2 );
                append( sb, "When set to true, the generated parser uses an input stream object that processes Java Unicode escapes (\\uxxxx) before sending characters to the token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "jdkVersion", 2 );
                append( sb, "The Java version for which to generate source code. Default value is 1.5 for plugin version 2.6+ and 1.4 in older versions.", 3 );
                append( sb, "", 0 );

                append( sb, "keepLineColumn", 2 );
                append( sb, "A flag whether to keep line and column information along with a token. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "lookAhead", 2 );
                append( sb, "The number of tokens to look ahead before making a decision at a choice point during parsing. The default value is 1.", 3 );
                append( sb, "", 0 );

                append( sb, "otherAmbiguityCheck", 2 );
                append( sb, "This is the number of tokens considered in checking all other kinds of choices (i.e., of the forms \'(A)*\', \'(A)+\', and \'(A)?\') for ambiguity. Default value is 1.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/javacc)", 2 );
                append( sb, "The directory where the parser files generated by JavaCC will be stored. The directory will be registered as a compile source root of the project such that the generated files will participate in later build phases like compiling and packaging.", 3 );
                append( sb, "", 0 );

                append( sb, "packageName", 2 );
                append( sb, "Deprecated. As of version 2.4 because the plugin extracts the package name from each grammar file.", 3 );
                append( sb, "", 0 );
                append( sb, "Package into which the generated classes will be put. Note that this will also be used to create the directory structure where sources will be generated. Defaults to the package name specified in a grammar file.", 3 );
                append( sb, "", 0 );

                append( sb, "sanityCheck", 2 );
                append( sb, "Enables/disables many syntactic and semantic checks on the grammar file during parser generation. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: ${basedir}/src/main/javacc)", 2 );
                append( sb, "The directory where the JavaCC grammar files (*.jj) are located.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "supportClassVisibilityPublic", 2 );
                append( sb, "A flag whether the generated support classes of the parser should have public or package-private visibility. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "tokenExtends", 2 );
                append( sb, "The name of the base class for the generated Token class. Default value is java.lang.Object.", 3 );
                append( sb, "", 0 );

                append( sb, "tokenFactory", 2 );
                append( sb, "The name of a custom factory class used to create Token objects. This class must have a method with the signature public static Token newToken(int ofKind, String image). By default, tokens are created by calling Token.newToken().", 3 );
                append( sb, "", 0 );

                append( sb, "tokenManagerUsesParser", 2 );
                append( sb, "When set to true, the generated token manager will include a field called parser that references the instantiating parser instance. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "unicodeInput", 2 );
                append( sb, "When set to true, the generated parser uses uses an input stream object that reads Unicode files. By default, ASCII files are assumed. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "userCharStream", 2 );
                append( sb, "This flag controls whether the token manager will read characters from a character stream reader as defined by the options javaUnicodeEscape and unicodeInput or whether the token manager reads from a user-supplied implementation of CharStream. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "userTokenManager", 2 );
                append( sb, "The default action is to generate a token manager that works on the specified grammar tokens. If this option is set to true, then the parser is generated to accept tokens from any token manager of type TokenManager - this interface is generated into the generated parser directory. Default value is false.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jjdoc".equals( goal ) )
        {
            append( sb, "javacc:jjdoc", 0 );
            append( sb, "JJDoc takes a JavaCC parser specification and produces documentation for the BNF grammar. This mojo will search the source directory for all *.jj files and run JJDoc once for each file it finds. Each of these output files, along with an index.html file will be placed in the site directory (target/site/jjdoc), and a link will be created in the \'Project Reports\' menu of the generated site.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "bnf", 2 );
                append( sb, "A flag whether to generate a plain text document with the unformatted BNF. Note that setting this option to true is only effective if the parameter text is false. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "cssHref", 2 );
                append( sb, "The hypertext reference to an optional CSS file for the generated HTML documents. If specified, this CSS file will be included via a <link> element in the HTML documents. Otherwise, the default style will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "grammarEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use for reading the grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "jjdocDirectory (Default: jjdoc)", 2 );
                append( sb, "The relative path of the JJDoc reports in the output directory. This path will be appended to the output directory.", 3 );
                append( sb, "", 0 );

                append( sb, "oneTable (Default: true)", 2 );
                append( sb, "This option controls the structure of the generated HTML output. If set to true, a single HTML table for the entire BNF is generated. Setting it to false will produce one table for every production in the grammar.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "The destination directory where JJDoc saves the generated documentation files. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectories", 2 );
                append( sb, "The directories where the JavaCC grammar files (*.jj) are located. By default, the directories ${basedir}/src/main/javacc, ${project.build.directory}/generated-sources/jjtree and ${project.build.directory}/generated-sources/jtb are scanned for grammar files to document.", 3 );
                append( sb, "", 0 );

                append( sb, "text", 2 );
                append( sb, "A flag to specify the output format for the generated documentation. If set to true, JJDoc will generate a plain text description of the BNF. Some formatting is done via tab characters, but the intention is to leave it as plain as possible. Specifying false causes JJDoc to generate a hyperlinked HTML document unless the parameter bnf has been set to true. Default value is false.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jjtree".equals( goal ) )
        {
            append( sb, "javacc:jjtree", 0 );
            append( sb, "Deprecated. As of version 2.4, use the jjtree-javacc goal instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Parses a JJTree grammar file (*.jjt) and transforms it to Java source files and a JavaCC grammar file. Please see the JJTree Reference Documentation for more information.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "buildNodeFiles", 2 );
                append( sb, "A flag whether to generate sample implementations for SimpleNode and any other nodes used in the grammar. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A set of Ant-like exclusion patterns used to prevent certain files from being processed. By default, this set is empty such that no files are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A set of Ant-like inclusion patterns used to select files from the source directory for processing. By default, the patterns **/*.jjt and **/*.JJT are used to select grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "isStatic", 2 );
                append( sb, "A flag whether to generate code for a static parser. Note that this setting must match the corresponding option for the javacc mojo. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "jdkVersion", 2 );
                append( sb, "The Java version for which to generate source code. Default value is 1.4.", 3 );
                append( sb, "", 0 );

                append( sb, "multi", 2 );
                append( sb, "A flag whether to generate a multi mode parse tree or a single mode parse tree. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeClass", 2 );
                append( sb, "The name of a custom class that extends SimpleNode and will be used as the super class for the generated tree node classes. By default, the tree node classes will directly extend the class SimpleNode.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeDefaultVoid", 2 );
                append( sb, "A flag whether to make each non-decorated production void instead of an indefinite node. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeFactory", 2 );
                append( sb, "The name of a custom factory class used to create Node objects. This class must have a method with the signature public static Node jjtCreate(int id). By default, the class SimpleNode will be used as the factory class.", 3 );
                append( sb, "", 0 );

                append( sb, "nodePackage", 2 );
                append( sb, "The package to generate the AST node classes into. This value may use a leading asterisk to reference the package of the corresponding parser. For example, if the parser package is org.apache and this parameter is set to *.demo, the tree node classes will be located in the package org.apache.demo. By default, the package of the corresponding parser is used.", 3 );
                append( sb, "", 0 );

                append( sb, "nodePrefix", 2 );
                append( sb, "The prefix used to construct node class names from node identifiers in multi mode. Default value is AST.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeScopeHook", 2 );
                append( sb, "A flag whether user-defined parser methods should be called on entry and exit of every node scope. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeUsesParser", 2 );
                append( sb, "A flag whether the node construction routines need an additional method parameter to receive the parser object. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/jjtree)", 2 );
                append( sb, "Directory where the output Java files for the node classes and the JavaCC grammar file will be located.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: ${basedir}/src/main/jjtree)", 2 );
                append( sb, "Directory where the input JJTree files (*.jjt) are located.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "timestampDirectory (Default: ${project.build.directory}/generated-sources/jjtree-timestamp)", 2 );
                append( sb, "The directory to store the processed input files for later detection of stale sources.", 3 );
                append( sb, "", 0 );

                append( sb, "trackTokens", 2 );
                append( sb, "A flag whether to insert the methods jjtGetFirstToken(), jjtSetFirstToken(), getLastToken() and jjtSetLastToken() into the class SimpleNode. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "visitor", 2 );
                append( sb, "A flag whether to insert a jjtAccept() method in the node classes and to generate a visitor implementation with an entry for every node type used in the grammar. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorDataType", 2 );
                append( sb, "The name of a class to use for the data argument of the jjtAccept() and visit() methods. Default value is java.lang.Object.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorException", 2 );
                append( sb, "The name of an exception class to include in the signature of the generated jjtAccept() and visit() methods. By default, the throws clause of the generated methods is empty such that only unchecked exceptions can be thrown.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorReturnType", 2 );
                append( sb, "The name of a class to use as the return type of the jjtAccept() and visit() methods. Default value is java.lang.Object.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jjtree-javacc".equals( goal ) )
        {
            append( sb, "javacc:jjtree-javacc", 0 );
            append( sb, "Preprocesses decorated grammar files (*.jjt) with JJTree and passes the output to JavaCC in order to finally generate a parser with parse tree actions.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "buildNodeFiles", 2 );
                append( sb, "A flag whether to generate sample implementations for SimpleNode and any other nodes used in the grammar. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "buildParser", 2 );
                append( sb, "A flag that controls whether the parser file (*Parser.java) should be generated or not. If set to false, only the token manager is generated. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "buildTokenManager", 2 );
                append( sb, "A flag that controls whether the token manager file (*TokenManager.java) should be generated or not. Setting this to false can speed up the generation process if only the parser part of the grammar changed. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "cacheTokens", 2 );
                append( sb, "Setting this option to true causes the generated parser to lookahead for extra tokens ahead of time. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "choiceAmbiguityCheck", 2 );
                append( sb, "This is the number of tokens considered in checking choices of the form \'A | B | ...\' for ambiguity. Default value is 2.", 3 );
                append( sb, "", 0 );

                append( sb, "commonTokenAction", 2 );
                append( sb, "When set to true, every call to the token manager\'s method getNextToken() (see the description of the Java Compiler Compiler API) will cause a call to a user-defined method CommonTokenAction() after the token has been scanned in by the token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "debugLookAhead", 2 );
                append( sb, "This is a boolean option whose default value is false. Setting this option to true causes the parser to generate all the tracing information it does when the option debugParser is true, and in addition, also causes it to generated a trace of actions performed during lookahead operation.", 3 );
                append( sb, "", 0 );

                append( sb, "debugParser", 2 );
                append( sb, "This option is used to obtain debugging information from the generated parser. Setting this option to true causes the parser to generate a trace of its actions. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "debugTokenManager", 2 );
                append( sb, "This option is used to obtain debugging information from the generated token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "errorReporting", 2 );
                append( sb, "Setting it to false causes errors due to parse errors to be reported in somewhat less detail. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A set of Ant-like exclusion patterns used to prevent certain files from being processed. By default, this set is empty such that no files are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "forceLaCheck", 2 );
                append( sb, "This option setting controls lookahead ambiguity checking performed by JavaCC. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "grammarEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use for reading the grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreCase", 2 );
                append( sb, "Setting this option to true causes the generated token manager to ignore case in the token specifications and the input files. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A set of Ant-like inclusion patterns used to select files from the source directory for processing. By default, the patterns **/*.jj, **/*.JJ, **/*.jjt and **/*.JJT are used to select grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "interimDirectory (Default: ${project.build.directory}/generated-sources/jjtree)", 2 );
                append( sb, "The directory where the AST node files generated by JJTree will be stored. The directory will be registered as a compile source root of the project such that the generated files will participate in later build phases like compiling and packaging.", 3 );
                append( sb, "", 0 );

                append( sb, "isStatic", 2 );
                append( sb, "If true, all methods and class variables are specified as static in the generated parser and token manager. This allows only one parser object to be present, but it improves the performance of the parser. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "javaUnicodeEscape", 2 );
                append( sb, "When set to true, the generated parser uses an input stream object that processes Java Unicode escapes (\\uxxxx) before sending characters to the token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "jdkVersion", 2 );
                append( sb, "The Java version for which to generate source code. Default value is 1.5 for plugin version 2.6+ and 1.4 in older versions.", 3 );
                append( sb, "", 0 );

                append( sb, "keepLineColumn", 2 );
                append( sb, "A flag whether to keep line and column information along with a token. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "lookAhead", 2 );
                append( sb, "The number of tokens to look ahead before making a decision at a choice point during parsing. The default value is 1.", 3 );
                append( sb, "", 0 );

                append( sb, "multi", 2 );
                append( sb, "A flag whether to generate a multi mode parse tree or a single mode parse tree. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeClass", 2 );
                append( sb, "The name of a custom class that extends SimpleNode and will be used as the super class for the generated tree node classes. By default, the tree node classes will directly extend the class SimpleNode.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeDefaultVoid", 2 );
                append( sb, "A flag whether to make each non-decorated production void instead of an indefinite node. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeFactory", 2 );
                append( sb, "The name of a custom factory class used to create Node objects. This class must have a method with the signature public static Node jjtCreate(int id). By default, the class SimpleNode will be used as the factory class.", 3 );
                append( sb, "", 0 );

                append( sb, "nodePackage", 2 );
                append( sb, "The package to generate the AST node classes into. This value may use a leading asterisk to reference the package of the corresponding parser. For example, if the parser package is org.apache and this parameter is set to *.node, the tree node classes will be located in the package org.apache.node. By default, the package of the corresponding parser is used.", 3 );
                append( sb, "", 0 );

                append( sb, "nodePrefix", 2 );
                append( sb, "The prefix used to construct node class names from node identifiers in multi mode. Default value is AST.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeScopeHook", 2 );
                append( sb, "A flag whether user-defined parser methods should be called on entry and exit of every node scope. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeUsesParser", 2 );
                append( sb, "A flag whether the node construction routines need an additional method parameter to receive the parser object. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "otherAmbiguityCheck", 2 );
                append( sb, "This is the number of tokens considered in checking all other kinds of choices (i.e., of the forms \'(A)*\', \'(A)+\', and \'(A)?\') for ambiguity. Default value is 1.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/javacc)", 2 );
                append( sb, "The directory where the parser files generated by JavaCC will be stored. The directory will be registered as a compile source root of the project such that the generated files will participate in later build phases like compiling and packaging.", 3 );
                append( sb, "", 0 );

                append( sb, "sanityCheck", 2 );
                append( sb, "Enables/disables many syntactic and semantic checks on the grammar file during parser generation. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: ${basedir}/src/main/jjtree)", 2 );
                append( sb, "The directory where the decorated JavaCC grammar files (*.jjt) are located. It will be recursively scanned for input files to pass to JJTree. The parameters includes and excludes can be used to select a subset of files.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a grammar file needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "supportClassVisibilityPublic", 2 );
                append( sb, "A flag whether the generated support classes of the parser should have public or package-private visibility. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "tokenExtends", 2 );
                append( sb, "The name of the base class for the generated Token class. Default value is java.lang.Object.", 3 );
                append( sb, "", 0 );

                append( sb, "tokenFactory", 2 );
                append( sb, "The name of a custom factory class used to create Token objects. This class must have a method with the signature public static Token newToken(int ofKind, String image). By default, tokens are created by calling Token.newToken().", 3 );
                append( sb, "", 0 );

                append( sb, "tokenManagerUsesParser", 2 );
                append( sb, "When set to true, the generated token manager will include a field called parser that references the instantiating parser instance. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "trackTokens", 2 );
                append( sb, "A flag whether to insert the methods jjtGetFirstToken(), jjtSetFirstToken(), getLastToken() and jjtSetLastToken() into the class SimpleNode. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "unicodeInput", 2 );
                append( sb, "When set to true, the generated parser uses uses an input stream object that reads Unicode files. By default, ASCII files are assumed. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "userCharStream", 2 );
                append( sb, "This flag controls whether the token manager will read characters from a character stream reader as defined by the options javaUnicodeEscape and unicodeInput or whether the token manager reads from a user-supplied implementation of CharStream. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "userTokenManager", 2 );
                append( sb, "The default action is to generate a token manager that works on the specified grammar tokens. If this option is set to true, then the parser is generated to accept tokens from any token manager of type TokenManager - this interface is generated into the generated parser directory. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "visitor", 2 );
                append( sb, "A flag whether to insert a jjtAccept() method in the node classes and to generate a visitor implementation with an entry for every node type used in the grammar. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorDataType", 2 );
                append( sb, "The name of a class to use for the data argument of the jjtAccept() and visit() methods. Default value is java.lang.Object.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorException", 2 );
                append( sb, "The name of an exception class to include in the signature of the generated jjtAccept() and visit() methods. By default, the throws clause of the generated methods is empty such that only unchecked exceptions can be thrown.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorReturnType", 2 );
                append( sb, "The name of a class to use as the return type of the jjtAccept() and visit() methods. Default value is java.lang.Object.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jtb".equals( goal ) )
        {
            append( sb, "javacc:jtb", 0 );
            append( sb, "Deprecated. As of version 2.4, use the jtb-javacc goal instead.", 1 );
            if ( detail )
            {
                append( sb, "", 0 );
                append( sb, "Parses a JTB file and transforms it into source files for an AST and a JavaCC grammar file which automatically builds the AST.\n\nNote: JTB requires Java 1.5 or higher. This goal will not work with earlier versions of the JRE.", 1 );
            }
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "descriptiveFieldNames", 2 );
                append( sb, "Setting this option to true causes JTB to generate field names that reflect the structure of the tree instead of generic names like f0, f1 etc. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A set of Ant-like exclusion patterns used to prevent certain files from being processed. By default, this set is empty such that no files are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A set of Ant-like inclusion patterns used to select files from the source directory for processing. By default, the patterns **/*.jtb and **/*.JTB are used to select grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocFriendlyComments", 2 );
                append( sb, "If true, all generated comments will be wrapped in <pre> tags so that they are formatted correctly in API docs. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "nodePackageName", 2 );
                append( sb, "This option specifies the package for the generated AST nodes. This value may use a leading asterisk to reference the package of the corresponding parser. For example, if the parser package is org.apache and this parameter is set to *.demo, the tree node classes will be located in the package org.apache.demo. Default value is *.syntaxtree.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeParentClass", 2 );
                append( sb, "The qualified name of a user-defined class from which all AST nodes will inherit. By default, AST nodes will inherit from the generated class Node.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/jtb)", 2 );
                append( sb, "The directory where the output Java files will be located.", 3 );
                append( sb, "", 0 );

                append( sb, "packageName", 2 );
                append( sb, "This option is short for nodePackageName = <packageName>.syntaxtree and visitorPackageName = <packageName>.visitor. Note that this option takes precedence over nodePackageName and visitorPackageName if specified.", 3 );
                append( sb, "", 0 );

                append( sb, "parentPointers", 2 );
                append( sb, "If true, all nodes will contain fields for its parent node. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "printer", 2 );
                append( sb, "If true, JTB will generate a syntax tree dumping visitor. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "scheme", 2 );
                append( sb, "If true, JTB will generate the following files to support the Schema programming language:\n-\tScheme records representing the grammar.\n-\tA Scheme tree building visitor.\nDefault value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: ${basedir}/src/main/jtb)", 2 );
                append( sb, "The directory where the JavaCC grammar files (*.jtb) are located. It will be recursively scanned for input files to pass to JTB.", 3 );
                append( sb, "", 0 );

                append( sb, "specialTokens", 2 );
                append( sb, "If true, JTB will include JavaCC \'special tokens\' in the AST. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "supressErrorChecking", 2 );
                append( sb, "If true, JTB will suppress its semantic error checking. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "timestampDirectory (Default: ${project.build.directory}/generated-sources/jtb-timestamp)", 2 );
                append( sb, "The directory to store the processed input files for later detection of stale sources.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorPackageName", 2 );
                append( sb, "This option specifies the package for the generated visitors. This value may use a leading asterisk to reference the package of the corresponding parser. For example, if the parser package is org.apache and this parameter is set to *.demo, the visitor classes will be located in the package org.apache.demo. Default value is *.visitor.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jtb-javacc".equals( goal ) )
        {
            append( sb, "javacc:jtb-javacc", 0 );
            append( sb, "Preprocesses ordinary grammar files (*.jtb) with JTB and passes the output to JavaCC in order to finally generate a parser with parse tree actions.\n\nNote: JTB requires Java 1.5 or higher. This goal will not work with earlier versions of the JRE.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "buildParser", 2 );
                append( sb, "A flag that controls whether the parser file (*Parser.java) should be generated or not. If set to false, only the token manager is generated. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "buildTokenManager", 2 );
                append( sb, "A flag that controls whether the token manager file (*TokenManager.java) should be generated or not. Setting this to false can speed up the generation process if only the parser part of the grammar changed. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "cacheTokens", 2 );
                append( sb, "Setting this option to true causes the generated parser to lookahead for extra tokens ahead of time. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "choiceAmbiguityCheck", 2 );
                append( sb, "This is the number of tokens considered in checking choices of the form \'A | B | ...\' for ambiguity. Default value is 2.", 3 );
                append( sb, "", 0 );

                append( sb, "commonTokenAction", 2 );
                append( sb, "When set to true, every call to the token manager\'s method getNextToken() (see the description of the Java Compiler Compiler API) will cause a call to a user-defined method CommonTokenAction() after the token has been scanned in by the token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "debugLookAhead", 2 );
                append( sb, "This is a boolean option whose default value is false. Setting this option to true causes the parser to generate all the tracing information it does when the option debugParser is true, and in addition, also causes it to generated a trace of actions performed during lookahead operation.", 3 );
                append( sb, "", 0 );

                append( sb, "debugParser", 2 );
                append( sb, "This option is used to obtain debugging information from the generated parser. Setting this option to true causes the parser to generate a trace of its actions. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "debugTokenManager", 2 );
                append( sb, "This option is used to obtain debugging information from the generated token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "descriptiveFieldNames", 2 );
                append( sb, "Setting this option to true causes JTB to generate field names that reflect the structure of the tree instead of generic names like f0, f1 etc. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "errorReporting", 2 );
                append( sb, "Setting it to false causes errors due to parse errors to be reported in somewhat less detail. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A set of Ant-like exclusion patterns used to prevent certain files from being processing. By default, this set is empty such that no files are excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "forceLaCheck", 2 );
                append( sb, "This option setting controls lookahead ambiguity checking performed by JavaCC. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "grammarEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use for reading the grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreCase", 2 );
                append( sb, "Setting this option to true causes the generated token manager to ignore case in the token specifications and the input files. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A set of Ant-like inclusion patterns used to select files from the source directory for processing. By default, the patterns **/*.jj, **/*.JJ, **/*.jtb and **/*.JTB are used to select grammar files.", 3 );
                append( sb, "", 0 );

                append( sb, "interimDirectory (Default: ${project.build.directory}/generated-sources/jtb)", 2 );
                append( sb, "The directory where the visitor and AST node files generated by JTB will be stored. The directory will be registered as a compile source root of the project such that the generated files will participate in later build phases like compiling and packaging.", 3 );
                append( sb, "", 0 );

                append( sb, "isStatic", 2 );
                append( sb, "If true, all methods and class variables are specified as static in the generated parser and token manager. This allows only one parser object to be present, but it improves the performance of the parser. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "javadocFriendlyComments", 2 );
                append( sb, "If true, all generated comments will be wrapped in <pre> tags so that they are formatted correctly in API docs. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "javaUnicodeEscape", 2 );
                append( sb, "When set to true, the generated parser uses an input stream object that processes Java Unicode escapes (\\uxxxx) before sending characters to the token manager. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "jdkVersion", 2 );
                append( sb, "The Java version for which to generate source code. Default value is 1.5 for plugin version 2.6+ and 1.4 in older versions.", 3 );
                append( sb, "", 0 );

                append( sb, "keepLineColumn", 2 );
                append( sb, "A flag whether to keep line and column information along with a token. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "lookAhead", 2 );
                append( sb, "The number of tokens to look ahead before making a decision at a choice point during parsing. The default value is 1.", 3 );
                append( sb, "", 0 );

                append( sb, "nodePackageName", 2 );
                append( sb, "This option specifies the package for the generated AST nodes. This value may use a leading asterisk to reference the package of the corresponding parser. For example, if the parser package is org.apache and this parameter is set to *.demo, the tree node classes will be located in the package org.apache.demo. Default value is *.syntaxtree.", 3 );
                append( sb, "", 0 );

                append( sb, "nodeParentClass", 2 );
                append( sb, "The qualified name of a user-defined class from which all AST nodes will inherit. By default, AST nodes will inherit from the generated class Node.", 3 );
                append( sb, "", 0 );

                append( sb, "otherAmbiguityCheck", 2 );
                append( sb, "This is the number of tokens considered in checking all other kinds of choices (i.e., of the forms \'(A)*\', \'(A)+\', and \'(A)?\') for ambiguity. Default value is 1.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/javacc)", 2 );
                append( sb, "The directory where the parser files generated by JavaCC will be stored. The directory will be registered as a compile source root of the project such that the generated files will participate in later build phases like compiling and packaging.", 3 );
                append( sb, "", 0 );

                append( sb, "packageName", 2 );
                append( sb, "This option is short for nodePackageName = <packageName>.syntaxtree and visitorPackageName = <packageName>.visitor. Note that this option takes precedence over nodePackageName and visitorPackageName if specified.", 3 );
                append( sb, "", 0 );

                append( sb, "parentPointers", 2 );
                append( sb, "If true, all nodes will contain fields for its parent node. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "printer", 2 );
                append( sb, "If true, JTB will generate a syntax tree dumping visitor. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "sanityCheck", 2 );
                append( sb, "Enables/disables many syntactic and semantic checks on the grammar file during parser generation. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "scheme", 2 );
                append( sb, "If true, JTB will generate the following files to support the Schema programming language:\n-\tScheme records representing the grammar.\n-\tA Scheme tree building visitor.\nDefault value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: ${basedir}/src/main/jtb)", 2 );
                append( sb, "The directory where the JavaCC grammar files (*.jtb) are located. It will be recursively scanned for input files to pass to JTB. The parameters includes and excludes can be used to select a subset of files.", 3 );
                append( sb, "", 0 );

                append( sb, "specialTokens", 2 );
                append( sb, "If true, JTB will include JavaCC \'special tokens\' in the AST. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "staleMillis (Default: 0)", 2 );
                append( sb, "The granularity in milliseconds of the last modification date for testing whether a grammar file needs recompilation.", 3 );
                append( sb, "", 0 );

                append( sb, "supportClassVisibilityPublic", 2 );
                append( sb, "A flag whether the generated support classes of the parser should have public or package-private visibility. Default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "supressErrorChecking", 2 );
                append( sb, "If true, JTB will suppress its semantic error checking. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "tokenExtends", 2 );
                append( sb, "The name of the base class for the generated Token class. Default value is java.lang.Object.", 3 );
                append( sb, "", 0 );

                append( sb, "tokenFactory", 2 );
                append( sb, "The name of a custom factory class used to create Token objects. This class must have a method with the signature public static Token newToken(int ofKind, String image). By default, tokens are created by calling Token.newToken().", 3 );
                append( sb, "", 0 );

                append( sb, "tokenManagerUsesParser", 2 );
                append( sb, "When set to true, the generated token manager will include a field called parser that references the instantiating parser instance. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "unicodeInput", 2 );
                append( sb, "When set to true, the generated parser uses uses an input stream object that reads Unicode files. By default, ASCII files are assumed. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "userCharStream", 2 );
                append( sb, "This flag controls whether the token manager will read characters from a character stream reader as defined by the options javaUnicodeEscape and unicodeInput or whether the token manager reads from a user-supplied implementation of CharStream. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "userTokenManager", 2 );
                append( sb, "The default action is to generate a token manager that works on the specified grammar tokens. If this option is set to true, then the parser is generated to accept tokens from any token manager of type TokenManager - this interface is generated into the generated parser directory. Default value is false.", 3 );
                append( sb, "", 0 );

                append( sb, "visitorPackageName", 2 );
                append( sb, "This option specifies the package for the generated visitors. This value may use a leading asterisk to reference the package of the corresponding parser. For example, if the parser package is org.apache and this parameter is set to *.demo, the visitor classes will be located in the package org.apache.demo. Default value is *.visitor.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
