/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rat.FilesReportable;
import org.codehaus.mojo.rat.HeaderMatcherSpecification;
import org.codehaus.mojo.rat.LicenseFamilySpecification;
import org.codehaus.plexus.util.DirectoryScanner;
import rat.Defaults;
import rat.Report;
import rat.analysis.IHeaderMatcher;
import rat.analysis.util.HeaderMatcherMultiplexer;
import rat.license.ILicenseFamily;
import rat.report.IReportable;
import rat.report.RatReportFailedException;

public abstract class AbstractRatMojo
extends AbstractMojo {
    public static final String[] MAVEN_DEFAULT_EXCLUDES = new String[]{"target/**/*", "cobertura.ser"};
    public static final String[] ECLIPSE_DEFAULT_EXCLUDES = new String[]{".classpath", ".project", ".settings/**/*"};
    public static final String[] IDEA_DEFAULT_EXCLUDES = new String[]{"*.iml", "*.ipr", "*.iws"};
    protected File basedir;
    private HeaderMatcherSpecification[] licenseMatchers;
    private LicenseFamilySpecification[] licenseFamilyNames;
    private boolean addDefaultLicenseMatchers;
    private String[] includes;
    private String[] excludes;
    private boolean useDefaultExcludes;
    private boolean useMavenDefaultExcludes;
    private boolean useEclipseDefaultExcludes;
    private boolean useIdeaDefaultExcludes;
    private boolean excludeSubProjects;
    private MavenProject project;
    static /* synthetic */ Class class$rat$analysis$IHeaderMatcher;
    static /* synthetic */ Class class$rat$license$ILicenseFamily;

    protected MavenProject getProject() {
        return this.project;
    }

    protected IHeaderMatcher[] getLicenseMatchers() throws MojoFailureException, MojoExecutionException {
        ArrayList<IHeaderMatcher> list = new ArrayList<IHeaderMatcher>();
        if (this.licenseMatchers != null) {
            for (int i = 0; i < this.licenseMatchers.length; ++i) {
                HeaderMatcherSpecification spec = this.licenseMatchers[i];
                String className = spec.getClassName();
                IHeaderMatcher headerMatcher = (IHeaderMatcher)this.newInstance(class$rat$analysis$IHeaderMatcher == null ? AbstractRatMojo.class$("rat.analysis.IHeaderMatcher") : class$rat$analysis$IHeaderMatcher, className);
                list.add(headerMatcher);
            }
        }
        if (this.addDefaultLicenseMatchers) {
            list.addAll(Arrays.asList(Defaults.DEFAULT_MATCHERS));
        }
        return list.toArray(new IHeaderMatcher[list.size()]);
    }

    private Object newInstance(Class clazz, String className) throws MojoExecutionException, MojoFailureException {
        Object o;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            o = cl.loadClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Failed to instantiate class " + className + ": " + e.getMessage(), (Exception)e);
        }
        catch (ClassCastException e) {
            throw new MojoExecutionException("The class " + className + " is not implementing " + clazz.getName() + ": " + e.getMessage(), (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Illegal access to class " + className + ": " + e.getMessage(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Class " + className + " not found: " + e.getMessage(), (Exception)e);
        }
        if (!clazz.isAssignableFrom(o.getClass())) {
            throw new MojoFailureException("The class " + o.getClass().getName() + " does not implement " + clazz.getName());
        }
        return o;
    }

    private void add(List pList, String[] pArray) {
        if (pArray != null) {
            for (int i = 0; i < pArray.length; ++i) {
                pList.add(pArray[i]);
            }
        }
    }

    protected IReportable getResources() {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.basedir);
        this.setExcludes(ds);
        this.setIncludes(ds);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        try {
            return new FilesReportable(this.basedir, files);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void setIncludes(DirectoryScanner ds) {
        if (this.includes != null) {
            ds.setIncludes(this.includes);
        }
    }

    private void setExcludes(DirectoryScanner ds) {
        ArrayList<String> excludeList1 = new ArrayList<String>();
        if (this.useDefaultExcludes) {
            this.add(excludeList1, DirectoryScanner.DEFAULTEXCLUDES);
        }
        if (this.useMavenDefaultExcludes) {
            this.add(excludeList1, MAVEN_DEFAULT_EXCLUDES);
        }
        if (this.useEclipseDefaultExcludes) {
            this.add(excludeList1, ECLIPSE_DEFAULT_EXCLUDES);
        }
        if (this.useIdeaDefaultExcludes) {
            this.add(excludeList1, IDEA_DEFAULT_EXCLUDES);
        }
        if (this.excludeSubProjects && this.project != null && this.project.getModules() != null) {
            Iterator it = this.project.getModules().iterator();
            while (it.hasNext()) {
                String moduleSubPath = (String)it.next();
                excludeList1.add(moduleSubPath + "/**/*");
            }
        }
        ArrayList<String> excludeList = excludeList1;
        this.add(excludeList, this.excludes);
        if (!excludeList.isEmpty()) {
            String[] allExcludes = excludeList.toArray(new String[excludeList.size()]);
            ds.setExcludes(allExcludes);
        }
    }

    protected void createReport(PrintWriter out, InputStream style) throws MojoExecutionException, MojoFailureException {
        HeaderMatcherMultiplexer m = new HeaderMatcherMultiplexer(this.getLicenseMatchers());
        try {
            Report.report((Writer)out, (IReportable)this.getResources(), (InputStream)style, (IHeaderMatcher)m, (ILicenseFamily[])this.getApprovedLicenseNames());
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (RatReportFailedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private ILicenseFamily[] getApprovedLicenseNames() throws MojoExecutionException, MojoFailureException {
        if (this.licenseFamilyNames == null || this.licenseFamilyNames.length == 0) {
            return null;
        }
        ILicenseFamily[] results = new ILicenseFamily[this.licenseFamilyNames.length];
        for (int i = 0; i < this.licenseFamilyNames.length; ++i) {
            ILicenseFamily licenseFamily;
            LicenseFamilySpecification spec = this.licenseFamilyNames[i];
            results[i] = licenseFamily = (ILicenseFamily)this.newInstance(class$rat$license$ILicenseFamily == null ? AbstractRatMojo.class$("rat.license.ILicenseFamily") : class$rat$license$ILicenseFamily, spec.getClassName());
        }
        return results;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

