/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.dir.DirectoryArchiver;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;

final class FilteringDirectoryArchiver
extends DirectoryArchiver {
    private MavenFileFilter mavenFileFilter;
    private List<FileUtils.FilterWrapper> filterWrappers;
    private boolean filter;

    FilteringDirectoryArchiver() {
    }

    public MavenFileFilter getMavenFileFilter() {
        return this.mavenFileFilter;
    }

    public void setMavenFileFilter(MavenFileFilter mavenFileFilter) {
        this.mavenFileFilter = mavenFileFilter;
    }

    public List<FileUtils.FilterWrapper> getFilterWrappers() {
        return this.filterWrappers;
    }

    public void setFilterWrappers(List<FileUtils.FilterWrapper> filterWrappers) {
        this.filterWrappers = filterWrappers;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public void resetArchiver() throws IOException {
        this.filterWrappers = null;
        this.filter = false;
        super.resetArchiver();
    }

    protected void copyFile(ArchiveEntry entry, String vPath) throws IOException {
        if (!this.filter || this.mavenFileFilter == null) {
            super.copyFile(entry, vPath);
        } else {
            if (vPath.length() <= 0) {
                return;
            }
            File inFile = ((PlexusIoFileResource)entry.getResource()).getFile();
            File outFile = new File(vPath);
            if (!inFile.isDirectory()) {
                try {
                    this.mavenFileFilter.copyFile(inFile, outFile, true, this.filterWrappers, null);
                }
                catch (MavenFilteringException e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            } else {
                super.copyFile(entry, vPath);
            }
        }
    }
}

