/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseReactorMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useReactor(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.isProcessingDependencies()) {
                this.useReactor(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useReactor(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        block0: for (Dependency dependency : dependencies) {
            Dependency dep = dependency;
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            for (Object reactorProject : this.reactorProjects) {
                MavenProject project = (MavenProject)reactorProject;
                if (!StringUtils.equals((String)project.getGroupId(), (String)dep.getGroupId()) || !StringUtils.equals((String)project.getArtifactId(), (String)dep.getArtifactId()) || StringUtils.equals((String)project.getVersion(), (String)dep.getVersion())) continue;
                if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), project.getVersion())) continue block0;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + project.getVersion()));
                continue block0;
            }
        }
    }
}

