/*
 * Decompiled with CFR 0.152.
 */
package com.codehaus.mojo.vfs;

import com.codehaus.mojo.vfs.FileSystemOptionsFactory;
import com.codehaus.mojo.vfs.FtpSettings;
import com.codehaus.mojo.vfs.SftpSettings;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractVfsMojo
extends AbstractMojo {
    @Parameter(required=false)
    protected FtpSettings ftpSettings = new FtpSettings();
    @Parameter(required=false)
    protected SftpSettings sftpSettings = new SftpSettings();
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="skip", defaultValue="false")
    protected boolean skip = false;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    protected FileSystemOptionsFactory fileSystemOptionsFactory = new FileSystemOptionsFactory();
    private StandardFileSystemManager fileSystemManager;

    protected FileSystemOptions getFileSystemOptions(String serverId, String sourceUrl) throws SecDispatcherException, FileSystemException {
        Server serverSettings = this.getServerSettings(serverId);
        this.fileSystemOptionsFactory.setFtpSettings(this.ftpSettings);
        this.fileSystemOptionsFactory.setSftpSettings(this.sftpSettings);
        return this.fileSystemOptionsFactory.getFileSystemOptions(sourceUrl, serverSettings.getUsername(), serverSettings.getPassword());
    }

    private Server getServerSettings(String serverId) throws SecDispatcherException {
        Server server = this.settings.getServer(serverId);
        if (server != null) {
            if (server.getPassword() != null) {
                server.setPassword(this.securityDispatcher.decrypt(server.getPassword()));
            }
        } else {
            server = new Server();
            if ("ftp.anonymous".equals("serverId")) {
                server.setId("ftp.anonymous");
                server.setUsername("anonymous");
                server.setPassword("anonymous@anonymous.com");
            }
        }
        return server;
    }

    protected synchronized FileSystemManager getFileSystemManager() throws FileSystemException {
        if (this.fileSystemManager != null) {
            return this.fileSystemManager;
        }
        this.fileSystemManager = new StandardFileSystemManager();
        try {
            Class<?> smbProviderClass = Class.forName("org.apache.commons.vfs2.provider.smb.SmbFileProvider");
            this.fileSystemManager.addProvider("smb", (FileProvider)smbProviderClass.newInstance());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)"VFS smb/cifs provider not available");
        }
        this.fileSystemManager.init();
        return this.fileSystemManager;
    }
}

