/*
 * Decompiled with CFR 0.152.
 */
package com.codehaus.mojo.vfs;

import com.codehaus.mojo.vfs.FtpSettings;
import com.codehaus.mojo.vfs.SftpSettings;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.codehaus.plexus.util.StringUtils;

public class FileSystemOptionsFactory {
    private FtpSettings ftpSettings = new FtpSettings();
    private SftpSettings sftpSettings = new SftpSettings();

    public void setFtpSettings(FtpSettings ftpSettings) {
        this.ftpSettings = ftpSettings;
    }

    public void setSftpSettings(SftpSettings sftpSettings) {
        this.sftpSettings = sftpSettings;
    }

    public FileSystemOptions getFileSystemOptions(String url, String username, String password) throws FileSystemException {
        FtpFileSystemConfigBuilder builder;
        FileSystemOptions opts = new FileSystemOptions();
        String[] tokens = StringUtils.split((String)url, (String)":");
        String protocol = tokens[0];
        if ("ftp".equals(protocol)) {
            builder = FtpFileSystemConfigBuilder.getInstance();
            builder.setPassiveMode(opts, this.ftpSettings.isPassiveMode());
            builder.setUserDirIsRoot(opts, this.ftpSettings.isUserDirIsRoot());
        }
        if ("sftp".equals(protocol)) {
            builder = SftpFileSystemConfigBuilder.getInstance();
            builder.setUserDirIsRoot(opts, this.sftpSettings.isUserDirIsRoot());
        }
        String domain = null;
        tokens = StringUtils.split((String)"\\");
        if (tokens.length == 2) {
            domain = tokens[0];
            username = tokens[1];
        }
        StaticUserAuthenticator auth = new StaticUserAuthenticator(domain, username, password);
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)auth);
        return opts;
    }
}

