/*
 * Decompiled with CFR 0.152.
 */
package com.codehaus.mojo.vfs;

import com.codehaus.mojo.vfs.AbstractVfsMojo;
import com.codehaus.mojo.vfs.MojoVfsFileSet;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.vfs.BaseFileSet;
import org.codehaus.mojo.vfs.VfsFileSet;
import org.codehaus.mojo.vfs.VfsUtils;
import org.codehaus.mojo.vfs.internal.DefaultVfsFileSetManager;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="list", requiresProject=false, threadSafe=true)
public class ListVfsMojo
extends AbstractVfsMojo {
    @Parameter(property="source", required=true)
    private String source;
    @Parameter(property="sourceId", required=false)
    private String sourceId;
    @Parameter(property="includes", required=false)
    private String includes;
    @Parameter(property="excludes", required=false)
    private String excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip VFS list operation");
            return;
        }
        MojoVfsFileSet fileset = new MojoVfsFileSet();
        fileset.setSource(this.source);
        fileset.setSourceId(this.sourceId);
        if (!StringUtils.isBlank((String)this.includes)) {
            fileset.setIncludes(StringUtils.split((String)this.includes, (String)","));
        }
        if (!StringUtils.isBlank((String)this.excludes)) {
            fileset.setExcludes(StringUtils.split((String)this.excludes, (String)","));
        }
        try {
            FileSystemOptions serverOptions = this.getFileSystemOptions(this.sourceId, this.source);
            VfsFileSet vfsFileSet = new VfsFileSet();
            vfsFileSet.copyBase((BaseFileSet)fileset);
            FileObject sourceObj = this.getFileSystemManager().resolveFile(fileset.getSource(), serverOptions);
            vfsFileSet.setSource(sourceObj);
            DefaultVfsFileSetManager fileSetManager = new DefaultVfsFileSetManager();
            List list = fileSetManager.list(vfsFileSet);
            this.getLog().info((CharSequence)"Directory list: ");
            for (FileObject fo : list) {
                this.getLog().info((CharSequence)VfsUtils.getRelativePath((FileObject)sourceObj, (FileObject)fo));
            }
        }
        catch (FileSystemException e) {
            throw new MojoFailureException("Unable to perform a list operation", (Throwable)e);
        }
        catch (SecDispatcherException e) {
            throw new MojoFailureException("Unable to perform a list operation", (Throwable)e);
        }
    }
}

