/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc;

import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.commonjava.util.jhttpc.INTERNAL.conn.ConnectionManagerCache;
import org.commonjava.util.jhttpc.INTERNAL.conn.ConnectionManagerTracker;
import org.commonjava.util.jhttpc.INTERNAL.conn.SiteConnectionConfig;
import org.commonjava.util.jhttpc.INTERNAL.conn.TrackedHttpClient;
import org.commonjava.util.jhttpc.INTERNAL.util.CertEnumerator;
import org.commonjava.util.jhttpc.INTERNAL.util.MonolithicKeyStrategy;
import org.commonjava.util.jhttpc.INTERNAL.util.SSLUtils;
import org.commonjava.util.jhttpc.JHttpCException;
import org.commonjava.util.jhttpc.auth.PasswordKey;
import org.commonjava.util.jhttpc.auth.PasswordManager;
import org.commonjava.util.jhttpc.auth.PasswordType;
import org.commonjava.util.jhttpc.model.SiteConfig;
import org.commonjava.util.jhttpc.model.SiteTrustType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFactory
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PasswordManager passwords;
    private final ConnectionManagerCache connectionCache;

    public HttpFactory(PasswordManager passwords) {
        this.passwords = passwords;
        this.connectionCache = new ConnectionManagerCache();
    }

    public PasswordManager getPasswordManager() {
        return this.passwords;
    }

    public CloseableHttpClient createClient() throws JHttpCException {
        return this.createClient(null);
    }

    public CloseableHttpClient createClient(SiteConfig location) throws JHttpCException {
        CloseableHttpClient client;
        if (location != null) {
            HttpClientBuilder builder = HttpClients.custom();
            this.logger.debug("Using site config: {} for advanced client options", (Object)location);
            SiteConnectionConfig connConfig = new SiteConnectionConfig(location);
            SSLConnectionSocketFactory sslFac = this.createSSLSocketFactory(location);
            if (sslFac != null) {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslFac);
                connConfig.withSSLConnectionSocketFactory(sslFac);
            }
            ConnectionManagerTracker managerWrapper = this.connectionCache.getTrackerFor(connConfig);
            builder.setConnectionManager((HttpClientConnectionManager)managerWrapper.acquire());
            if (location.getProxyHost() != null) {
                DefaultProxyRoutePlanner planner = new DefaultProxyRoutePlanner(new HttpHost(location.getProxyHost(), this.getProxyPort(location)));
                builder.setRoutePlanner((HttpRoutePlanner)planner);
            }
            int timeout = 1000 * location.getRequestTimeoutSeconds();
            builder.setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).setConnectTimeout(timeout).build());
            client = new TrackedHttpClient(builder.build(), managerWrapper);
        } else {
            client = HttpClients.createDefault();
        }
        return client;
    }

    private int getProxyPort(SiteConfig location) {
        int port = location.getProxyPort();
        if (port < 1) {
            port = -1;
        }
        return port;
    }

    public HttpClientContext createContext() throws JHttpCException {
        return this.createContext(null);
    }

    public HttpClientContext createContext(SiteConfig location) throws JHttpCException {
        HttpClientContext ctx = HttpClientContext.create();
        if (location != null) {
            String password;
            AuthScope as;
            BasicCredentialsProvider creds = new BasicCredentialsProvider();
            try {
                as = new AuthScope(location.getHost(), location.getPort());
            }
            catch (MalformedURLException e) {
                throw new JHttpCException("Failed to parse site URL for host and port: %s (site id: %s). Reason: %s", (Throwable)e, location.getUri(), location.getId(), e.getMessage());
            }
            if (location.getUser() != null) {
                password = this.passwords.lookup(new PasswordKey(location, PasswordType.USER));
                creds.setCredentials(as, (Credentials)new UsernamePasswordCredentials(location.getUser(), password));
            }
            if (location.getProxyHost() != null && location.getProxyUser() != null) {
                password = this.passwords.lookup(new PasswordKey(location, PasswordType.PROXY));
                creds.setCredentials(new AuthScope(location.getProxyHost(), this.getProxyPort(location)), (Credentials)new UsernamePasswordCredentials(location.getProxyUser(), password));
            }
            ctx.setCredentialsProvider((CredentialsProvider)creds);
        }
        return ctx;
    }

    private SSLConnectionSocketFactory createSSLSocketFactory(SiteConfig location) throws JHttpCException {
        KeyStore ks = null;
        KeyStore ts = null;
        String kcPem = location.getKeyCertPem();
        String kcPass = this.passwords.lookup(new PasswordKey(location, PasswordType.KEY));
        if (kcPem != null) {
            this.logger.debug("Adding client key/certificate from: {}", (Object)location);
            if (kcPass == null || kcPass.length() < 1) {
                this.logger.error("Invalid configuration. Location: {} cannot have an empty key password!", (Object)location.getUri());
                throw new JHttpCException("Location: " + location.getUri() + " is misconfigured! Key password cannot be empty.", new Object[0]);
            }
            try {
                this.logger.debug("Reading Client SSL key from:\n\n{}\n\n", (Object)kcPem);
                ks = SSLUtils.readKeyAndCert(kcPem, kcPass);
                this.logger.debug("Keystore contains the following certificates: {}", (Object)new CertEnumerator(ks, kcPass));
            }
            catch (CertificateException e) {
                this.logger.error(String.format("Invalid configuration. Location: %s has an invalid client certificate! Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (KeyStoreException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (InvalidKeySpecException e) {
                this.logger.error(String.format("Invalid configuration. Invalid client key for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (IOException e) {
                throw new JHttpCException("Failed to read client SSL key/certificate from: %s. Reason: %s", (Throwable)e, location, e.getMessage());
            }
            catch (JHttpCException e) {
                throw new JHttpCException("Failed to read client SSL key/certificate from: %s. Reason: %s", (Throwable)e, location, e.getMessage());
            }
        } else {
            this.logger.debug("No client key/certificate found");
        }
        String sPem = location.getServerCertPem();
        if (sPem != null) {
            this.logger.debug("Adding server certificate(s) from: {}", (Object)location);
            try {
                this.logger.debug("Reading Server SSL cert from:\n\n{}\n\n", (Object)sPem);
                ts = SSLUtils.readCerts(sPem, location.getHost());
            }
            catch (CertificateException e) {
                this.logger.error(String.format("Invalid configuration. Location: %s has an invalid server certificate! Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (KeyStoreException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error(String.format("Invalid configuration. Cannot initialize keystore for repository: %s. Error: %s", location.getUri(), e.getMessage()), (Throwable)e);
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (IOException e) {
                throw new JHttpCException("Failed to read server SSL certificate(s) (or couldn't parse server hostname) from: %s. Reason: %s", (Throwable)e, location, e.getMessage());
            }
        } else {
            this.logger.debug("No server certificates found");
        }
        if (ks != null || ts != null) {
            this.logger.debug("Setting up SSL context.");
            try {
                SSLContextBuilder sslBuilder = SSLContexts.custom().useProtocol("TLS");
                if (ks != null) {
                    this.logger.debug("Loading key material for SSL context...");
                    MonolithicKeyStrategy pkStrategy = new MonolithicKeyStrategy();
                    sslBuilder.loadKeyMaterial(ks, kcPass.toCharArray(), (PrivateKeyStrategy)pkStrategy);
                }
                if (ts != null) {
                    this.logger.debug("Loading trust material for SSL context...");
                    SiteTrustType trustType = location.getTrustType();
                    if (trustType == null) {
                        trustType = SiteTrustType.DEFAULT;
                    }
                    sslBuilder.loadTrustMaterial(ts, (TrustStrategy)trustType.getTrustStrategy());
                }
                SSLContext ctx = sslBuilder.build();
                return new SSLConnectionSocketFactory(ctx, (HostnameVerifier)new DefaultHostnameVerifier());
            }
            catch (KeyManagementException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (UnrecoverableKeyException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
            catch (KeyStoreException e) {
                this.logger.error("Invalid configuration. Cannot initialize SSL socket factory for repository: {}. Error: {}", new Object[]{e, location.getUri(), e.getMessage()});
                throw new JHttpCException("Failed to initialize SSL connection for repository: " + location.getUri(), new Object[0]);
            }
        }
        this.logger.debug("No SSL configuration present; no SSL context created.");
        return null;
    }

    @Override
    public void close() throws IOException {
    }
}

