/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.commonjava.util.jhttpc.INTERNAL.conn.CloseBlockingConnectionManager;
import org.commonjava.util.jhttpc.INTERNAL.conn.SiteConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerTracker {
    private SiteConnectionConfig config;
    private CloseBlockingConnectionManager manager;
    private int users = 0;
    private boolean detached;
    private long lastRetrieval;

    public ConnectionManagerTracker(SiteConnectionConfig config) {
        this.config = config;
    }

    public synchronized CloseBlockingConnectionManager acquire() {
        if (this.manager == null) {
            PoolingHttpClientConnectionManager poolingMgr = new PoolingHttpClientConnectionManager(this.config.getSocketFactoryRegistry());
            poolingMgr.setMaxTotal(this.config.getMaxConnections());
            this.manager = new CloseBlockingConnectionManager(this.config, (HttpClientConnectionManager)poolingMgr);
        }
        ++this.users;
        return this.manager;
    }

    public synchronized void release() {
        --this.users;
        this.tryShutdown();
    }

    private void tryShutdown() {
        if (this.detached && this.users < 1) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.debug("Shutdown connection manager: {}", (Object)this);
            this.manager.reallyShutdown();
        }
    }

    public long getLastRetrieval() {
        return this.lastRetrieval;
    }

    public ConnectionManagerTracker retrieved() {
        this.lastRetrieval = System.currentTimeMillis();
        return this;
    }

    public void detach() {
        this.detached = true;
        this.tryShutdown();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionManagerTracker that = (ConnectionManagerTracker)o;
        return this.config.equals(that.config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public String toString() {
        return "ConnectionManagerTracker{config=" + this.config + ", manager=" + this.manager + ", instance=" + super.hashCode() + '}';
    }
}

