/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.commonjava.util.jhttpc.INTERNAL.conn.ConnectionManagerTracker;
import org.commonjava.util.jhttpc.INTERNAL.util.HttpUtils;

public class TrackedHttpClient
extends CloseableHttpClient {
    private final CloseableHttpClient delegate;
    private final ConnectionManagerTracker managerWrapper;
    private Set<WeakReference<HttpRequest>> requests = new HashSet<WeakReference<HttpRequest>>();
    private Set<WeakReference<CloseableHttpResponse>> responses = new HashSet<WeakReference<CloseableHttpResponse>>();

    public TrackedHttpClient(CloseableHttpClient delegate, ConnectionManagerTracker managerWrapper) {
        this.delegate = delegate;
        this.managerWrapper = managerWrapper;
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        this.requests.add(new WeakReference<HttpRequest>(request));
        CloseableHttpResponse response = this.delegate.execute(target, request, context);
        this.responses.add(new WeakReference<CloseableHttpResponse>(response));
        return response;
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.delegate.execute(target, request, context);
    }

    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.delegate.execute(request, context);
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.delegate.execute(request);
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.delegate.execute(target, request);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.delegate.execute(target, request, responseHandler, context);
    }

    public void close() throws IOException {
        HttpUtils.cleanupResources(this.delegate, this.requests, this.responses);
        if (this.managerWrapper != null) {
            this.managerWrapper.release();
        }
    }

    @Deprecated
    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }
}

