/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.bc.BcPEMDecryptorProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.commonjava.util.jhttpc.INTERNAL.util.SSLUtils;
import org.commonjava.util.jhttpc.JHttpCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleUtils {
    public static KeyStore readKeyAndCertFromPem(String pemContent, String keyPass) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, JHttpCException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        List<String> lines = SSLUtils.readLines(pemContent);
        Object currentHeader = null;
        StringBuilder current = new StringBuilder();
        int certIdx = 0;
        Logger logger = LoggerFactory.getLogger(SSLUtils.class);
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        InputDecryptorProvider provider = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider((Provider)bcProvider).build(keyPass.toCharArray());
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        PrivateKey key = null;
        PEMParser pemParser = new PEMParser((Reader)new StringReader(pemContent));
        Object pemObj = null;
        while ((pemObj = pemParser.readObject()) != null) {
            logger.debug("Got PEM object: {}", pemObj);
            if (pemObj instanceof X509CertificateHolder) {
                X509CertificateHolder holder = (X509CertificateHolder)pemObj;
                X509Certificate certificate = new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(holder);
                certs.add(certificate);
                HashSet<String> aliases = new HashSet<String>();
                aliases.add("certificate" + certIdx);
                SSLUtils.extractAliases(certificate, aliases);
                KeyStore.TrustedCertificateEntry ksEntry = new KeyStore.TrustedCertificateEntry(certificate);
                for (String alias : aliases) {
                    ks.setEntry(alias, ksEntry, null);
                    logger.debug("Storing trusted cert under alias: {}\n  with DN: {}", (Object)alias, (Object)certificate.getSubjectDN().getName());
                }
                ++certIdx;
                continue;
            }
            if (pemObj instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo keyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObj;
                PrivateKeyInfo privateKeyInfo = null;
                try {
                    privateKeyInfo = keyInfo.decryptPrivateKeyInfo(provider);
                }
                catch (PKCSException e) {
                    throw new JHttpCException("Failed to decrypt key/certificate: %s", (Throwable)e, e.getMessage());
                }
                key = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                continue;
            }
            if (!(pemObj instanceof PEMEncryptedKeyPair)) continue;
            PEMEncryptedKeyPair keyPair = (PEMEncryptedKeyPair)pemObj;
            PEMKeyPair decryptedKeyPair = keyPair.decryptKeyPair((PEMDecryptorProvider)new BcPEMDecryptorProvider(keyPass.toCharArray()));
            PrivateKeyInfo privateKeyInfo = decryptedKeyPair.getPrivateKeyInfo();
            key = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        }
        if (key != null && !certs.isEmpty()) {
            logger.debug("Setting key entry: {}", key);
            ks.setKeyEntry("key", key, keyPass.toCharArray(), certs.toArray(new Certificate[certs.size()]));
        } else {
            logger.debug("No private key found in PEM!");
        }
        return ks;
    }
}

