/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.util;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public final class CertEnumerator {
    private final KeyStore ks;
    private String kcPass;

    public CertEnumerator(KeyStore ks, String kcPass) {
        this.ks = ks;
        this.kcPass = kcPass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            Enumeration<String> aliases = this.ks.aliases();
            while (aliases.hasMoreElements()) {
                Key key;
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                sb.append("\nAlias: ").append(alias);
                if (cert != null) {
                    sb.append("\n\t").append(cert.getSubjectDN());
                }
                if ((key = this.ks.getKey(alias, this.kcPass.toCharArray())) == null) continue;
                sb.append("\n\t").append(key.getAlgorithm()).append(" private key.");
            }
        }
        catch (KeyStoreException e) {
            sb.append("ERROR READING KEYSTORE");
        }
        catch (UnrecoverableKeyException e) {
            sb.append("ERROR READING KEY");
        }
        catch (NoSuchAlgorithmException e) {
            sb.append("ERROR READING KEY");
        }
        return sb.toString();
    }
}

