/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cthul.objects.internal.BoxingBase;

public class Boxing
extends BoxingBase {
    private static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    private static final Class<?>[] BOXES = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class};
    private static final int I_BOOLEAN = 0;
    private static final int I_BYTE = 1;
    private static final int I_CHARACTER = 2;
    private static final int I_DOUBLE = 3;
    private static final int I_FLOAT = 4;
    private static final int I_INTEGER = 5;
    private static final int I_LONG = 6;
    private static final int I_SHORT = 7;
    private static final Map<Class<?>, Class<?>> BOXED = new HashMap();
    private static final Map<Class<?>, Class<?>> UNBOXED = new HashMap();
    private static final Map<Class<?>, Class<?>> AUTO_BOXED = new HashMap();
    private static final Map<Class<?>, Integer> INDICES = new HashMap();
    private static final Map<Class<?>, Class<?>> P_BOXED;
    private static final Map<Class<?>, Class<?>> P_UNBOXED;
    private static final Map<Class<?>, Class<?>> P_AUTO_BOXED;

    static {
        int i = 0;
        while (i < PRIMITIVES.length) {
            Class<?> prim = PRIMITIVES[i];
            Class<?> box = BOXES[i];
            BOXED.put(prim, box);
            UNBOXED.put(box, prim);
            AUTO_BOXED.put(prim, box);
            AUTO_BOXED.put(box, prim);
            INDICES.put(prim, i);
            INDICES.put(box, i);
            ++i;
        }
        P_BOXED = Collections.unmodifiableMap(BOXED);
        P_UNBOXED = Collections.unmodifiableMap(UNBOXED);
        P_AUTO_BOXED = Collections.unmodifiableMap(AUTO_BOXED);
    }

    public static Class<?> boxingType(Class<?> clazz) {
        return AUTO_BOXED.get(clazz);
    }

    public static Class<?> box(Class<?> type) {
        return BOXED.get(type);
    }

    public static Class<?> primitive(Class<?> clazz) {
        return UNBOXED.get(clazz);
    }

    public static Map<Class<?>, Class<?>> boxingTypes() {
        return P_AUTO_BOXED;
    }

    public static Map<Class<?>, Class<?>> boxes() {
        return P_BOXED;
    }

    public static Map<Class<?>, Class<?>> primitives() {
        return P_UNBOXED;
    }

    protected static int tId(Class<?> type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        Integer i = INDICES.get(type);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static Object unbox(Class<?> clazz, Object src) {
        return Boxing.box(clazz, src);
    }

    public static <T> T unboxAs(Object src, Class<T> clazz) {
        return Boxing.boxAs(src, clazz);
    }

    public static Object unboxAll(Class<?> type, Object[] src, int srcPos, int len) {
        switch (Boxing.tId(type)) {
            case 0: {
                return Boxing.unboxBooleans(src, srcPos, len);
            }
            case 1: {
                return Boxing.unboxBytes(src, srcPos, len);
            }
            case 2: {
                return Boxing.unboxCharacters(src, srcPos, len);
            }
            case 3: {
                return Boxing.unboxDoubles(src, srcPos, len);
            }
            case 4: {
                return Boxing.unboxFloats(src, srcPos, len);
            }
            case 5: {
                return Boxing.unboxIntegers(src, srcPos, len);
            }
            case 6: {
                return Boxing.unboxLongs(src, srcPos, len);
            }
            case 7: {
                return Boxing.unboxShorts(src, srcPos, len);
            }
        }
        throw new IllegalArgumentException("No primitive/box: " + type);
    }

    public static Object unboxAll(Class<?> type, Object[] src) {
        return Boxing.unboxAll(type, src, 0, -1);
    }

    public static Object unboxAll(Object[] src, int srcPos, int len) {
        if (srcPos >= src.length) {
            throw new IndexOutOfBoundsException(String.valueOf(srcPos));
        }
        Class<?> type = src[srcPos].getClass();
        return Boxing.unboxAll(type, src, srcPos, len);
    }

    public static Object unboxAll(Object[] src) {
        return Boxing.unboxAll(src, 0, -1);
    }

    public static Object unboxAll(Class<?> type, Object src, int srcPos, int len) {
        switch (Boxing.tId(type)) {
            case 0: {
                return Boxing.unboxBooleans(src, srcPos, len);
            }
            case 1: {
                return Boxing.unboxBytes(src, srcPos, len);
            }
            case 2: {
                return Boxing.unboxCharacters(src, srcPos, len);
            }
            case 3: {
                return Boxing.unboxDoubles(src, srcPos, len);
            }
            case 4: {
                return Boxing.unboxFloats(src, srcPos, len);
            }
            case 5: {
                return Boxing.unboxIntegers(src, srcPos, len);
            }
            case 6: {
                return Boxing.unboxLongs(src, srcPos, len);
            }
            case 7: {
                return Boxing.unboxShorts(src, srcPos, len);
            }
        }
        throw new IllegalArgumentException("No primitive/box: " + type);
    }

    public static Object unboxAll(Class<?> type, Object src) {
        return Boxing.unboxAll(type, src, 0, -1);
    }

    public static <T> T unboxAllAs(Object src, int srcPos, int len, Class<T> type) {
        return (T)Boxing.unboxAll(type, src, srcPos, len);
    }

    public static <T> T unboxAllAs(Object src, Class<T> type) {
        return (T)Boxing.unboxAll(type, src, 0, -1);
    }

    public static boolean[] unboxBooleans(Object src, int srcPos, int len) {
        return Boxing.unboxBooleans(Boxing.array(src), srcPos, len);
    }

    public static byte[] unboxBytes(Object src, int srcPos, int len) {
        return Boxing.unboxBytes(Boxing.array(src), srcPos, len);
    }

    public static char[] unboxCharacters(Object src, int srcPos, int len) {
        return Boxing.unboxCharacters(Boxing.array(src), srcPos, len);
    }

    public static float[] unboxFloats(Object src, int srcPos, int len) {
        return Boxing.unboxFloats(Boxing.array(src), srcPos, len);
    }

    public static double[] unboxDoubles(Object src, int srcPos, int len) {
        return Boxing.unboxDoubles(Boxing.array(src), srcPos, len);
    }

    public static int[] unboxIntegers(Object src, int srcPos, int len) {
        return Boxing.unboxIntegers(Boxing.array(src), srcPos, len);
    }

    public static long[] unboxLongs(Object src, int srcPos, int len) {
        return Boxing.unboxLongs(Boxing.array(src), srcPos, len);
    }

    public static short[] unboxShorts(Object src, int srcPos, int len) {
        return Boxing.unboxShorts(Boxing.array(src), srcPos, len);
    }

    public static boolean[] unboxBooleans(Object src) {
        return Boxing.unboxBooleans(src, 0, -1);
    }

    public static byte[] unboxBytes(Object src) {
        return Boxing.unboxBytes(src, 0, -1);
    }

    public static char[] unboxCharacters(Object src) {
        return Boxing.unboxCharacters(src, 0, -1);
    }

    public static float[] unboxFloats(Object src) {
        return Boxing.unboxFloats(src, 0, -1);
    }

    public static double[] unboxDoubles(Object src) {
        return Boxing.unboxDoubles(src, 0, -1);
    }

    public static int[] unboxIntegers(Object src) {
        return Boxing.unboxIntegers(src, 0, -1);
    }

    public static long[] unboxLongs(Object src) {
        return Boxing.unboxLongs(src, 0, -1);
    }

    public static short[] unboxShorts(Object src) {
        return Boxing.unboxShorts(src, 0, -1);
    }

    public static Object box(Class<?> type, Object src) {
        switch (Boxing.tId(type)) {
            case 0: {
                return Boxing.boxBoolean(src);
            }
            case 1: {
                return Boxing.boxByte(src);
            }
            case 2: {
                return Boxing.boxCharacter(src);
            }
            case 3: {
                return Boxing.boxDouble(src);
            }
            case 4: {
                return Boxing.boxFloat(src);
            }
            case 5: {
                return Boxing.boxInteger(src);
            }
            case 6: {
                return Boxing.boxLong(src);
            }
            case 7: {
                return Boxing.boxShort(src);
            }
        }
        throw new IllegalArgumentException("No primitive/box: " + type);
    }

    public static <T> T boxAs(Object src, Class<T> type) {
        return (T)Boxing.box(type, src);
    }

    public static Object[] boxAll(Object src, int srcPos, int len) {
        switch (Boxing.tId(src.getClass())) {
            case 0: {
                return Boxing.box((boolean[])src, srcPos, len);
            }
            case 1: {
                return Boxing.box((byte[])src, srcPos, len);
            }
            case 2: {
                return Boxing.box((char[])src, srcPos, len);
            }
            case 3: {
                return Boxing.box((double[])src, srcPos, len);
            }
            case 4: {
                return Boxing.box((float[])src, srcPos, len);
            }
            case 5: {
                return Boxing.box((int[])src, srcPos, len);
            }
            case 6: {
                return Boxing.box((long[])src, srcPos, len);
            }
            case 7: {
                return Boxing.box((short[])src, srcPos, len);
            }
        }
        throw new IllegalArgumentException("No primitive array: " + src);
    }

    public static Object[] boxAll(Object src) {
        return Boxing.boxAll(src, 0, -1);
    }

    public static Object[] boxAll(Class<?> type, Object src, int srcPos, int len) {
        switch (Boxing.tId(type)) {
            case 0: {
                return Boxing.boxBooleans(src, srcPos, len);
            }
            case 1: {
                return Boxing.boxBytes(src, srcPos, len);
            }
            case 2: {
                return Boxing.boxCharacters(src, srcPos, len);
            }
            case 3: {
                return Boxing.boxDoubles(src, srcPos, len);
            }
            case 4: {
                return Boxing.boxFloats(src, srcPos, len);
            }
            case 5: {
                return Boxing.boxIntegers(src, srcPos, len);
            }
            case 6: {
                return Boxing.boxLongs(src, srcPos, len);
            }
            case 7: {
                return Boxing.boxShorts(src, srcPos, len);
            }
        }
        throw new IllegalArgumentException("No primitive/box: " + type);
    }

    public static Object[] boxAll(Class<?> type, Object src) {
        return Boxing.boxAll(type, src, 0, -1);
    }

    public static <T> T boxAllAs(Object src, int srcPos, int len, Class<T> type) {
        return (T)Boxing.boxAll(type, src, srcPos, len);
    }

    public static <T> T boxAllAs(Object src, Class<T> type) {
        return (T)Boxing.boxAll(type, src, 0, -1);
    }

    public static Boolean[] boxBooleans(Object src, int srcPos, int len) {
        return Boxing.boxBooleans(Boxing.array(src), srcPos, len);
    }

    public static Byte[] boxBytes(Object src, int srcPos, int len) {
        return Boxing.boxBytes(Boxing.array(src), srcPos, len);
    }

    public static Character[] boxCharacters(Object src, int srcPos, int len) {
        return Boxing.boxCharacters(Boxing.array(src), srcPos, len);
    }

    public static Float[] boxFloats(Object src, int srcPos, int len) {
        return Boxing.boxFloats(Boxing.array(src), srcPos, len);
    }

    public static Double[] boxDoubles(Object src, int srcPos, int len) {
        return Boxing.boxDoubles(Boxing.array(src), srcPos, len);
    }

    public static Integer[] boxIntegers(Object src, int srcPos, int len) {
        return Boxing.boxIntegers(Boxing.array(src), srcPos, len);
    }

    public static Long[] boxLongs(Object src, int srcPos, int len) {
        return Boxing.boxLongs(Boxing.array(src), srcPos, len);
    }

    public static Short[] boxShorts(Object src, int srcPos, int len) {
        return Boxing.boxShorts(Boxing.array(src), srcPos, len);
    }

    public static Boolean[] boxBooleans(Object src) {
        return Boxing.boxBooleans(src, 0, -1);
    }

    public static Byte[] boxBytes(Object src) {
        return Boxing.boxBytes(src, 0, -1);
    }

    public static Character[] boxCharacters(Object src) {
        return Boxing.boxCharacters(src, 0, -1);
    }

    public static Float[] boxFloats(Object src) {
        return Boxing.boxFloats(src, 0, -1);
    }

    public static Double[] boxDoubles(Object src) {
        return Boxing.boxDoubles(src, 0, -1);
    }

    public static Integer[] boxIntegers(Object src) {
        return Boxing.boxIntegers(src, 0, -1);
    }

    public static Long[] boxLongs(Object src) {
        return Boxing.boxLongs(src, 0, -1);
    }

    public static Short[] boxShorts(Object src) {
        return Boxing.boxShorts(src, 0, -1);
    }

    static Class<?> arrayBoxingType(Class<?> clazz) {
        int dim = 0;
        while (clazz.isArray()) {
            ++dim;
            clazz = clazz.getComponentType();
        }
        Class<?> comp = Boxing.boxingType(clazz);
        int[] dims = new int[dim];
        Object tmpArray = Boxing.newArray(comp, dims);
        return tmpArray.getClass();
    }

    public static Object deepUnbox(Object[] src) {
        Class<?> resultType = Boxing.arrayBoxingType(src.getClass());
        return Boxing.deepUnbox(resultType, src);
    }

    public static Object deepUnbox(Class<?> type, Object src) {
        Class<?> compType = type.getComponentType();
        if (compType.isArray()) {
            Object[] src2 = (Object[])src;
            Object[] result = (Object[])Boxing.newArray(compType, src2.length);
            int i = 0;
            while (i < src2.length) {
                result[i] = Boxing.deepUnbox(compType, src2[i]);
                ++i;
            }
            return result;
        }
        return Boxing.unboxAll(compType, src, 0, -1);
    }

    public static <T> T deepUnboxAs(Object src, Class<T> result) {
        return (T)Boxing.deepUnbox(result, src);
    }

    public static Object deepBox(Object src) {
        Class<?> resultType = Boxing.arrayBoxingType(src.getClass());
        return Boxing.deepBox(resultType, src);
    }

    public static Object[] deepBox(Class<?> resultType, Object src) {
        Class<?> compType = resultType.getComponentType();
        if (compType.isArray()) {
            Object[] src2 = (Object[])src;
            Object[] result = (Object[])Boxing.newArray(compType, src2.length);
            int i = 0;
            while (i < src2.length) {
                result[i] = Boxing.deepBox(compType, src2[i]);
                ++i;
            }
            return result;
        }
        return Boxing.boxAll(compType, src, 0, -1);
    }

    public static <T> T deepBoxAs(Object src, Class<T> type) {
        return (T)Boxing.deepBox(type, src);
    }

    public static <T> T as(Object src, Class<T> type) {
        Class<Object> t = type;
        while (t.isArray()) {
            t = t.getComponentType();
        }
        if (t == type) {
            return Boxing.boxAs(src, type);
        }
        if (t.isPrimitive()) {
            return Boxing.deepUnboxAs(src, type);
        }
        return Boxing.deepBoxAs(src, type);
    }

    public static BoxingBase.Array array(Object array) {
        if (array instanceof Object[]) {
            return Boxing.array((Object[])array);
        }
        switch (Boxing.tId(array.getClass())) {
            case 0: {
                return Boxing.array((boolean[])array);
            }
            case 1: {
                return Boxing.array((byte[])array);
            }
            case 2: {
                return Boxing.array((char[])array);
            }
            case 3: {
                return Boxing.array((double[])array);
            }
            case 4: {
                return Boxing.array((float[])array);
            }
            case 5: {
                return Boxing.array((int[])array);
            }
            case 6: {
                return Boxing.array((long[])array);
            }
            case 7: {
                return Boxing.array((short[])array);
            }
        }
        throw new IllegalArgumentException("No array: " + array);
    }

    private static Object newArray(Class<?> elementType, int length) {
        return Array.newInstance(elementType, length);
    }

    private static Object newArray(Class<?> elementType, int ... dimensions) {
        return Array.newInstance(elementType, dimensions);
    }
}

