/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Types {
    public static Set<Class<?>> getSuperclasses(Class<?> clazz) {
        return Types.superclasses(clazz);
    }

    public static Set<Class<?>> superclasses(Class<?> clazz) {
        LinkedHashSet result = new LinkedHashSet();
        ArrayDeque queue = new ArrayDeque();
        if (clazz.isInterface()) {
            queue.add(Object.class);
        }
        while (clazz != null) {
            queue.add(clazz);
            clazz = clazz.getSuperclass();
        }
        while (!queue.isEmpty()) {
            Class c = (Class)queue.remove();
            if (!result.add(c)) continue;
            queue.addAll(Arrays.asList(c.getInterfaces()));
        }
        return result;
    }

    public static Set<Class<?>> commonSuperclasses(Class<?> ... classes) {
        return Types.commonSuperclasses(Arrays.asList(classes));
    }

    public static Set<Class<?>> commonSuperclasses(Iterable<Class<?>> classes) {
        Iterator<Class<?>> it = classes.iterator();
        if (!it.hasNext()) {
            return Collections.emptySet();
        }
        Set<Class<?>> result = Types.getSuperclasses(it.next());
        while (it.hasNext()) {
            Class<?> c = it.next();
            Iterator<Class<?>> resultIt = result.iterator();
            while (resultIt.hasNext()) {
                Class<?> sup = resultIt.next();
                if (sup.isAssignableFrom(c)) continue;
                resultIt.remove();
            }
        }
        return result;
    }

    public static List<Class<?>> lowestCommonSuperclasses(Class<?> ... classes) {
        return Types.lowestCommonSuperclasses(Arrays.asList(classes));
    }

    public static List<Class<?>> lowestCommonSuperclasses(Iterable<Class<?>> classes) {
        Set<Class<?>> commonSupers = Types.commonSuperclasses(classes);
        return Types.lowestClasses(commonSupers);
    }

    public static List<Class<?>> lowestClasses(Class<?> ... classes) {
        return Types.lowestClasses(Arrays.asList(classes));
    }

    public static List<Class<?>> lowestClasses(Collection<Class<?>> classes) {
        LinkedList source = new LinkedList(classes);
        ArrayList result = new ArrayList(classes.size());
        while (!source.isEmpty()) {
            Iterator srcIt = source.iterator();
            Class c = Object.class;
            while (srcIt.hasNext()) {
                Class c2 = (Class)srcIt.next();
                if (c2.isAssignableFrom(c)) {
                    srcIt.remove();
                    continue;
                }
                if (!c.isAssignableFrom(c2)) continue;
                c = c2;
                srcIt.remove();
            }
            boolean diamond = false;
            for (Class<?> c2 : result) {
                if (!c.isAssignableFrom(c2)) continue;
                diamond = true;
                break;
            }
            if (diamond) continue;
            result.add(c);
        }
        result.trimToSize();
        return result;
    }
}

