/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.reflection;

import java.lang.reflect.Constructor;
import org.cthul.objects.reflection.AmbiguousSignatureMatchException;
import org.cthul.objects.reflection.JavaSignatureComparator;
import org.cthul.objects.reflection.Signatures;

public class AmbiguousConstructorMatchException
extends AmbiguousSignatureMatchException {
    private final Constructor<?>[] allConstructors;
    private final Constructor<?>[] constructors;

    public AmbiguousConstructorMatchException(AmbiguousSignatureMatchException src, Constructor<?>[] allConstructors) {
        super(src);
        this.allConstructors = allConstructors;
        this.constructors = this.collectAmbiguousMethods(allConstructors);
    }

    public AmbiguousConstructorMatchException(JavaSignatureComparator jsCmp, Constructor<?>[] constructors) {
        super(jsCmp, Signatures.collectSignatures(constructors), Signatures.collectVarArgs(constructors));
        this.allConstructors = constructors;
        this.constructors = constructors;
    }

    public AmbiguousConstructorMatchException(JavaSignatureComparator jsCmp, Constructor<?>[] allConstructors, int[] ambiguousIndices) {
        super(jsCmp, Signatures.collectSignatures(allConstructors), Signatures.collectVarArgs(allConstructors), ambiguousIndices);
        this.allConstructors = allConstructors;
        this.constructors = this.collectAmbiguousMethods(allConstructors);
    }

    private Constructor<?>[] collectAmbiguousMethods(Constructor<?>[] allConstructors) {
        int[] indices = this.getAmbiguousIndices();
        Constructor[] result = new Constructor[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = allConstructors[indices[i]];
            ++i;
        }
        return result;
    }

    public Constructor<?>[] getAllConstructors() {
        return this.allConstructors;
    }

    public Constructor<?>[] getConstructors() {
        return this.constructors;
    }
}

