/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.reflection;

import java.lang.reflect.Method;
import org.cthul.objects.reflection.AmbiguousSignatureMatchException;
import org.cthul.objects.reflection.JavaSignatureComparator;
import org.cthul.objects.reflection.Signatures;

public class AmbiguousMethodMatchException
extends AmbiguousSignatureMatchException {
    private final Method[] allMethods;
    private final Method[] methods;

    public AmbiguousMethodMatchException(AmbiguousSignatureMatchException src, Method[] allMethods) {
        super(src);
        this.allMethods = allMethods;
        this.methods = this.collectAmbiguousMethods(allMethods);
    }

    public AmbiguousMethodMatchException(JavaSignatureComparator jsCmp, Method[] methods) {
        super(jsCmp, Signatures.collectSignatures(methods), Signatures.collectVarArgs(methods));
        this.allMethods = methods;
        this.methods = methods;
    }

    public AmbiguousMethodMatchException(JavaSignatureComparator jsCmp, Method[] allMethods, int[] ambiguousIndices) {
        super(jsCmp, Signatures.collectSignatures(allMethods), Signatures.collectVarArgs(allMethods), ambiguousIndices);
        this.allMethods = allMethods;
        this.methods = this.collectAmbiguousMethods(allMethods);
    }

    private Method[] collectAmbiguousMethods(Method[] allMethods) {
        int[] indices = this.getAmbiguousIndices();
        Method[] result = new Method[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = allMethods[indices[i]];
            ++i;
        }
        return result;
    }

    public Method[] getAllMethods() {
        return this.allMethods;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    @Override
    protected String buildMessage() {
        return AmbiguousMethodMatchException.methodList(this.getReferenceSignature(), this.getMethods());
    }

    protected static String methodList(Class<?>[] match, Method[] methods) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        AmbiguousMethodMatchException.printSig(sb, match, false);
        sb.append("): ");
        int i = 0;
        while (i < methods.length) {
            if (i > 0) {
                sb.append(", ");
            }
            Method m = methods[i];
            sb.append(m.getName());
            sb.append("(");
            AmbiguousMethodMatchException.printSig(sb, m.getParameterTypes(), m.isVarArgs());
            sb.append(")");
            ++i;
        }
        String result = sb.toString();
        if (result.length() > 70) {
            result = result.replace(" (", "\n    (");
        }
        return result;
    }
}

