/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.reflection;

import org.cthul.objects.reflection.JavaSignatureComparator;

public class AmbiguousSignatureMatchException
extends RuntimeException {
    private final JavaSignatureComparator jsCmp;
    private final Class<?>[][] allSignatures;
    private final boolean[] allVarArgs;
    private final Class<?>[][] signatures;
    private final boolean[] varArgs;
    private final int[] ambiguousIndices;
    private String message;

    protected AmbiguousSignatureMatchException(AmbiguousSignatureMatchException src) {
        this.jsCmp = src.jsCmp;
        this.allSignatures = src.allSignatures;
        this.allVarArgs = src.allVarArgs;
        this.signatures = src.signatures;
        this.varArgs = src.varArgs;
        this.ambiguousIndices = src.ambiguousIndices;
    }

    public AmbiguousSignatureMatchException(JavaSignatureComparator jsCmp, Class<?>[][] allSignatures, boolean[] allVarArgs, int[] ambiguousIndices) {
        this.jsCmp = jsCmp;
        this.allSignatures = allSignatures;
        this.allVarArgs = allVarArgs;
        this.ambiguousIndices = ambiguousIndices;
        this.signatures = new Class[ambiguousIndices.length][];
        this.varArgs = new boolean[ambiguousIndices.length];
        int i = 0;
        while (i < ambiguousIndices.length) {
            this.signatures[i] = allSignatures[ambiguousIndices[i]];
            this.varArgs[i] = allVarArgs[ambiguousIndices[i]];
            ++i;
        }
    }

    public AmbiguousSignatureMatchException(JavaSignatureComparator jsCmp, Class<?>[][] signatures, boolean[] varArgs) {
        this.jsCmp = jsCmp;
        this.allSignatures = signatures;
        this.allVarArgs = varArgs;
        this.signatures = signatures;
        this.varArgs = varArgs;
        this.ambiguousIndices = new int[signatures.length];
        int i = 0;
        while (i < this.ambiguousIndices.length) {
            this.ambiguousIndices[i] = i;
            ++i;
        }
    }

    public Class<?>[][] getAllSignatures() {
        return this.allSignatures;
    }

    public boolean[] getAllVarArgs() {
        return this.allVarArgs;
    }

    public Class<?>[][] getSignatures() {
        return this.signatures;
    }

    public boolean[] getVarArgs() {
        return this.varArgs;
    }

    public int[] getAmbiguousIndices() {
        return this.ambiguousIndices;
    }

    public JavaSignatureComparator getSignatureComparator() {
        return this.jsCmp;
    }

    public Class<?>[] getReferenceSignature() {
        return this.jsCmp.getReferenceSignature();
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            this.message = this.buildMessage();
        }
        return this.message;
    }

    protected String buildMessage() {
        return AmbiguousSignatureMatchException.sigList(this.getReferenceSignature(), this.getSignatures(), this.getVarArgs());
    }

    protected static String sigList(Class<?>[] match, Class<?>[][] signatures, boolean[] varArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        AmbiguousSignatureMatchException.printSig(sb, match, false);
        sb.append("): ");
        int i = 0;
        while (i < signatures.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("(");
            AmbiguousSignatureMatchException.printSig(sb, signatures[i], varArgs[i]);
            sb.append(")");
            ++i;
        }
        String result = sb.toString();
        if (result.length() > 70) {
            result = result.replace(" (", "\n    (");
        }
        return result;
    }

    protected static void printSig(StringBuilder sb, Class<?>[] sig, boolean varArgs) {
        int i = 0;
        while (i < sig.length) {
            if (i > 0) {
                sb.append(", ");
            }
            AmbiguousSignatureMatchException.printClass(sb, sig[i]);
            ++i;
        }
        if (varArgs) {
            sb.setLength(sb.length() - 2);
            sb.append("...");
        }
    }

    protected static void printClass(StringBuilder sb, Class<?> aClass) {
        if (aClass.isArray()) {
            AmbiguousSignatureMatchException.printClass(sb, aClass.getComponentType());
            sb.append("[]");
        } else {
            sb.append(aClass.getName());
        }
    }
}

