/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.cthul.objects.Boxing;
import org.cthul.objects.reflection.AmbiguousConstructorMatchException;
import org.cthul.objects.reflection.AmbiguousMethodMatchException;
import org.cthul.objects.reflection.AmbiguousSignatureMatchException;
import org.cthul.objects.reflection.JavaSignatureComparator;

public class Signatures {
    public static final int NONE = 0;
    public static final int ANY = 0;
    public static final int STATIC = 8;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int PUBLIC = 1;
    public static final int NOT_DEFAULT = 7;

    public static <T> Constructor<T> bestConstructor(Class<T> clazz, Object[] args) throws AmbiguousConstructorMatchException {
        return Signatures.bestConstructor(Signatures.collectConstructors(clazz), args);
    }

    public static <T> Constructor<T> bestConstructor(Class<T> clazz, Class<?>[] argTypes) throws AmbiguousConstructorMatchException {
        return Signatures.bestConstructor(Signatures.collectConstructors(clazz), argTypes);
    }

    public static <T> Constructor<T> bestConstructor(Constructor<T>[] constructors, Object[] args) throws AmbiguousConstructorMatchException {
        return Signatures.bestConstructor(constructors, Signatures.collectArgTypes(args));
    }

    public static <T> Constructor<T> bestConstructor(Constructor<T>[] constructors, Class<?>[] argTypes) throws AmbiguousConstructorMatchException {
        try {
            return Signatures.best(constructors, Signatures.collectSignatures(constructors), Signatures.collectVarArgs(constructors), argTypes);
        }
        catch (AmbiguousSignatureMatchException e) {
            throw new AmbiguousConstructorMatchException(e, constructors);
        }
    }

    public static <T> Constructor<T>[] candidateConstructors(Class<T> clazz, Object[] args) {
        return Signatures.candidateConstructors(Signatures.collectConstructors(clazz), args);
    }

    public static <T> Constructor<T>[] candidateConstructors(Class<T> clazz, Class<?>[] argTypes) {
        return Signatures.candidateConstructors(Signatures.collectConstructors(clazz), argTypes);
    }

    public static <T> Constructor<T>[] candidateConstructors(Constructor<T>[] constructors, Object[] args) {
        return Signatures.candidateConstructors(constructors, Signatures.collectArgTypes(args));
    }

    public static <T> Constructor<T>[] candidateConstructors(Constructor<T>[] constructors, Class<?>[] argTypes) {
        return Signatures.candidates(constructors, Signatures.collectSignatures(constructors), Signatures.collectVarArgs(constructors), argTypes);
    }

    public static Method bestMethod(Class<?> clazz, String name, Object[] args) throws AmbiguousMethodMatchException {
        return Signatures.bestMethod(Signatures.collectMethods(clazz, name), args);
    }

    public static Method bestMethod(Class<?> clazz, String name, Class<?>[] argTypes) throws AmbiguousMethodMatchException {
        return Signatures.bestMethod(Signatures.collectMethods(clazz, name), argTypes);
    }

    public static Method bestMethod(Method[] methods, Object[] args) throws AmbiguousMethodMatchException {
        return Signatures.bestMethod(methods, Signatures.collectArgTypes(args));
    }

    public static Method bestMethod(Method[] methods, Class<?>[] argTypes) throws AmbiguousMethodMatchException {
        try {
            return Signatures.best(methods, Signatures.collectSignatures(methods), Signatures.collectVarArgs(methods), argTypes);
        }
        catch (AmbiguousSignatureMatchException e) {
            throw new AmbiguousMethodMatchException(e, methods);
        }
    }

    public static Method[] candidateMethods(Class<?> clazz, String name, Object[] args) {
        return Signatures.candidateMethods(Signatures.collectMethods(clazz, name), args);
    }

    public static Method[] candidateMethods(Class<?> clazz, String name, Class<?>[] argTypes) {
        return Signatures.candidateMethods(Signatures.collectMethods(clazz, name), argTypes);
    }

    public static Method[] candidateMethods(Method[] methods, Object[] args) {
        return Signatures.candidateMethods(methods, Signatures.collectArgTypes(args));
    }

    public static Method[] candidateMethods(Method[] methods, Class<?>[] argTypes) {
        return Signatures.candidates(methods, Signatures.collectSignatures(methods), Signatures.collectVarArgs(methods), argTypes);
    }

    public static <T> T best(T[] items, Class<?>[][] signatures, boolean[] varArgs, Class<?>[] argTypes) throws AmbiguousSignatureMatchException {
        int i = Signatures.bestMatch(signatures, varArgs, argTypes);
        if (i < 0) {
            return null;
        }
        return items[i];
    }

    public static <T> T[] candidates(T[] items, Class<?>[][] signatures, boolean[] varArgs, Class<?>[] argTypes) {
        int[] indices = Signatures.candidateMatches(signatures, varArgs, argTypes);
        T[] result = Signatures.newArray(items.getClass().getComponentType(), indices.length);
        int i = 0;
        while (i < indices.length) {
            result[i] = items[indices[i]];
            ++i;
        }
        return result;
    }

    private static <T> T[] newArray(Class<?> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static Class<?>[] collectArgTypes(Collection<?> args) {
        Class[] result = new Class[args.size()];
        int i = 0;
        for (Object a : args) {
            result[i++] = Signatures.argType(a);
        }
        return result;
    }

    public static Class<?>[] collectArgTypes(Object[] args) {
        Class[] result = new Class[args.length];
        Signatures.collectArgTypes(args, result, 0, 0, args.length);
        return result;
    }

    public static void collectArgTypes(Object[] args, Class<?>[] types, int argIndex, int typeIndex, int length) {
        int i = 0;
        while (i < length) {
            Object a = args[i + argIndex];
            types[i + typeIndex] = Signatures.argType(a);
            ++i;
        }
    }

    private static Class<?> argType(Object a) {
        return a != null ? a.getClass() : null;
    }

    public static Method[] collectMethods(Class<?> clazz, String name) {
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name)) {
                result.add(m);
            }
            ++n2;
        }
        return result.toArray(new Method[result.size()]);
    }

    public static Method[] collectMethods(Class<?> clazz, String name, int include, int exclude) {
        ArrayList<Method> result = new ArrayList<Method>();
        Signatures.collectMethods(result, new ArrayList<Class<?>[]>(), new HashSet(), clazz, name, include, exclude);
        return result.toArray(new Method[result.size()]);
    }

    private static void collectMethods(List<Method> methods, List<Class<?>[]> signatures, Set<Class<?>> visited, Class<?> clazz, String name, int include, int exclude) {
        if (clazz == null || !visited.add(clazz)) {
            return;
        }
        GenericDeclaration[] genericDeclarationArray = clazz.getDeclaredMethods();
        int n = genericDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = genericDeclarationArray[n2];
            String n3 = m.getName();
            int mod = m.getModifiers();
            if (name.equals(n3) && Signatures.include(mod, include, exclude)) {
                Object[] sig = m.getParameterTypes();
                int len = methods.size();
                boolean isNew = true;
                int i = 0;
                while (i < len) {
                    if (n3.equals(methods.get(i).getName()) && Arrays.equals(sig, signatures.get(i))) {
                        isNew = false;
                        break;
                    }
                    ++i;
                }
                if (isNew) {
                    methods.add(m);
                    signatures.add((Class<?>[])sig);
                }
            }
            ++n2;
        }
        Signatures.collectMethods(methods, signatures, visited, clazz.getSuperclass(), name, include, exclude);
        genericDeclarationArray = clazz.getInterfaces();
        n = genericDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            GenericDeclaration i = genericDeclarationArray[n2];
            Signatures.collectMethods(methods, signatures, visited, i, name, include, exclude);
            ++n2;
        }
    }

    public static <T> Constructor<T>[] collectConstructors(Class<T> clazz) {
        return clazz.getConstructors();
    }

    public static <T> Constructor<T>[] collectConstructors(Class<T> clazz, int include, int exclude) {
        ArrayList result = new ArrayList();
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            int mod = c.getModifiers();
            if (Signatures.include(mod, include, exclude)) {
                result.add(c);
            }
            ++n2;
        }
        return result.toArray(new Constructor[result.size()]);
    }

    private static boolean include(int mod, int include, int exclude) {
        if (include == 0) {
            return (mod & exclude) == 0;
        }
        return (mod & include) == include && (mod & exclude) == 0;
    }

    public static Class<?>[][] collectSignatures(Method[] methods) {
        Class[][] result = new Class[methods.length][];
        int i = 0;
        while (i < methods.length) {
            result[i] = methods[i].getParameterTypes();
            ++i;
        }
        return result;
    }

    public static boolean[] collectVarArgs(Method[] methods) {
        boolean[] result = new boolean[methods.length];
        int i = 0;
        while (i < methods.length) {
            result[i] = methods[i].isVarArgs();
            ++i;
        }
        return result;
    }

    public static Class<?>[][] collectSignatures(Constructor<?>[] constructors) {
        Class[][] result = new Class[constructors.length][];
        int i = 0;
        while (i < constructors.length) {
            result[i] = constructors[i].getParameterTypes();
            ++i;
        }
        return result;
    }

    public static boolean[] collectVarArgs(Constructor<?>[] constructors) {
        boolean[] result = new boolean[constructors.length];
        int i = 0;
        while (i < constructors.length) {
            result[i] = constructors[i].isVarArgs();
            ++i;
        }
        return result;
    }

    public static int bestMatch(Class<?>[][] signatures, boolean[] varArgs, Class<?>[] argTypes) throws AmbiguousSignatureMatchException {
        return Signatures.bestMatch(signatures, varArgs, new JavaSignatureComparator(argTypes));
    }

    public static int bestMatch(Class<?>[][] signatures, boolean[] varArgs, JavaSignatureComparator jsCmp) throws AmbiguousSignatureMatchException {
        int bestLevel = -98;
        int bestIndex = -1;
        LinkedList<Integer> ambiguous = null;
        int i = 0;
        while (i < signatures.length) {
            Class<?>[] sig = signatures[i];
            boolean var = varArgs[i];
            int level = jsCmp.applicability(sig, var);
            if (level > bestLevel) {
                ambiguous = null;
                bestLevel = level;
                bestIndex = i;
            } else if (level == bestLevel) {
                if (ambiguous != null && !ambiguous.isEmpty()) {
                    boolean isAmbiguous = true;
                    Iterator it = ambiguous.iterator();
                    while (it.hasNext()) {
                        int a = (Integer)it.next();
                        int c = jsCmp.compareSpecificness(signatures[a], varArgs[a], sig, var);
                        if (c < 0) {
                            isAmbiguous = false;
                        }
                        if (c <= 0) continue;
                        it.remove();
                    }
                    if (isAmbiguous) {
                        if (ambiguous.isEmpty()) {
                            bestIndex = i;
                        } else {
                            ambiguous.add(i);
                        }
                    }
                } else {
                    assert (bestIndex > -1);
                    int c = jsCmp.compareSpecificness(signatures[bestIndex], varArgs[bestIndex], sig, var);
                    if (c > 0) {
                        bestIndex = i;
                    } else if (c == 0) {
                        if (ambiguous == null) {
                            ambiguous = new LinkedList<Integer>();
                        }
                        ambiguous.add(bestIndex);
                        ambiguous.add(i);
                    }
                }
            }
            ++i;
        }
        if (ambiguous != null) {
            if (ambiguous.size() > 1) {
                throw new AmbiguousSignatureMatchException(jsCmp, signatures, varArgs, Boxing.unboxIntegers(ambiguous));
            }
            if (ambiguous.size() == 1) {
                return (Integer)ambiguous.get(0);
            }
        }
        return bestIndex;
    }

    public static int[] candidateMatches(Class<?>[][] signatures, boolean[] varArgs, Class<?>[] argTypes) {
        return Signatures.candidateMatches(signatures, varArgs, new JavaSignatureComparator(argTypes));
    }

    public static int[] candidateMatches(Class<?>[][] signatures, boolean[] varArgs, JavaSignatureComparator jsCmp) {
        int bestLevel = -98;
        LinkedList<Integer> candidates = new LinkedList<Integer>();
        int i = 0;
        while (i < signatures.length) {
            Class<?>[] sig = signatures[i];
            boolean var = varArgs[i];
            int level = jsCmp.applicability(sig, var);
            if (level > bestLevel) {
                candidates.clear();
                bestLevel = level;
                candidates.add(i);
            } else if (level == bestLevel) {
                boolean isCandidate = true;
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    int k = (Integer)it.next();
                    int c = jsCmp.compareSpecificness(signatures[k], varArgs[k], sig, var);
                    if (c < 0) {
                        isCandidate = false;
                    }
                    if (c <= 0) continue;
                    it.remove();
                }
                if (isCandidate) {
                    candidates.add(i);
                }
            }
            ++i;
        }
        return Boxing.unboxIntegers(candidates);
    }

    public static Object[] fixVarArgs(Class<?>[] paramsWithVarArgs, Object[] arguments) {
        int n = paramsWithVarArgs.length;
        return Signatures.fixVarArgs(n, paramsWithVarArgs[n - 1], arguments);
    }

    public static Object[] fixVarArgs(int length, Class<?> varArgType, Object[] arguments) {
        Object varArgs;
        if (arguments.length == length && varArgType.isInstance(arguments[length - 1])) {
            return arguments;
        }
        Object[] result = Arrays.copyOf(arguments, length, Object[].class);
        Class<?> varArgElementType = varArgType.getComponentType();
        if (varArgElementType.isPrimitive()) {
            varArgs = Boxing.unboxAll(varArgElementType, arguments, length - 1, -1);
        } else {
            int varLen = arguments.length - length + 1;
            varArgs = Array.newInstance(varArgElementType, varLen);
            System.arraycopy(arguments, length - 1, varArgs, 0, varLen);
        }
        result[length - 1] = varArgs;
        return result;
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (constructor.isVarArgs()) {
            args = Signatures.fixVarArgs(constructor.getParameterTypes(), args);
        }
        return constructor.newInstance(args);
    }

    public static Object invoke(Object instance, Method method, Object ... args) throws IllegalAccessException, InvocationTargetException {
        if (method.isVarArgs()) {
            args = Signatures.fixVarArgs(method.getParameterTypes(), args);
        }
        return method.invoke(instance, args);
    }
}

