/*
 * Decompiled with CFR 0.152.
 */
package org.cthul.objects.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.cthul.objects.reflection.Signatures;
import org.cthul.objects.reflection.VirtualSwitch;

public class VirtualMethod<R> {
    private final Method[] methods;
    private final Class[] paramTypes;
    private final boolean varArgsSwitch;

    public static <R> VirtualMethod<R> instance(Class clazz, String name) {
        return VirtualSwitch.instance(clazz).get(name, 0, true, null);
    }

    public static <R> VirtualMethod<R> instance(Class clazz, String name, Class ... paramTypes) {
        return VirtualSwitch.instance(clazz).get(name, 0, true, paramTypes);
    }

    public static <R> VirtualMethod<R> instance(Class clazz, String name, boolean varArgSwitch, Class ... paramTypes) {
        return VirtualSwitch.instance(clazz).get(name, 0, varArgSwitch, paramTypes);
    }

    public static <R> VirtualMethod<R> instance(Class clazz, String name, int switchParamCount, Class ... moreParams) {
        return VirtualSwitch.instance(clazz).get(name, switchParamCount, true, moreParams);
    }

    public static <R> VirtualMethod<R> instance(Class clazz, String name, int switchParamCount, boolean varArgSwitch, Class ... moreParams) {
        return VirtualSwitch.instance(clazz).get(name, switchParamCount, varArgSwitch, moreParams);
    }

    public VirtualMethod(Class clazz, String name) {
        this(clazz, name, 0, true, null);
    }

    public VirtualMethod(Class clazz, String name, Class ... paramTypes) {
        this(clazz, name, 0, true, paramTypes);
    }

    public VirtualMethod(Class clazz, String name, boolean varArgsSwitch, Class ... paramTypes) {
        this(clazz, name, 0, varArgsSwitch, paramTypes);
    }

    public VirtualMethod(Class clazz, String name, int switchParamCount, Class ... moreParams) {
        this(clazz, name, switchParamCount, true, moreParams);
    }

    public VirtualMethod(Class clazz, String name, int switchParamCount, boolean varArgsSwitch, Class ... moreParams) {
        this.methods = Signatures.collectMethods(clazz, name, 0, 0);
        this.varArgsSwitch = varArgsSwitch;
        if (switchParamCount > 0 && moreParams != null) {
            this.paramTypes = new Class[moreParams.length + switchParamCount];
            System.arraycopy(moreParams, 0, this.paramTypes, switchParamCount, moreParams.length);
        } else {
            this.paramTypes = moreParams != null ? (Class[])moreParams.clone() : null;
        }
    }

    protected Class[] getParamTypes(Object[] args) {
        if (this.paramTypes == null) {
            return Signatures.collectArgTypes(args);
        }
        int len = this.varArgsSwitch ? args.length : this.paramTypes.length;
        Class[] params = Arrays.copyOf(this.paramTypes, len);
        int i = 0;
        while (i < params.length) {
            Object a;
            if (params[i] == null && (a = args[i]) != null) {
                params[i] = a.getClass();
            }
            ++i;
        }
        return params;
    }

    public R _invoke(Object self, Object ... args) {
        try {
            return this.invoke(self, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VirtualMethod.asRE(e);
        }
    }

    public R invoke(Object self, Object ... args) throws IllegalAccessException, InvocationTargetException {
        Class[] params = this.getParamTypes(args);
        Method m = Signatures.bestMethod(this.methods, params);
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        Object r = Signatures.invoke(self, m, args);
        return this.cast(r);
    }

    public R _invokeStatic(Object ... args) {
        try {
            return this.invokeStatic(args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VirtualMethod.asRE(e);
        }
    }

    public R invokeStatic(Object ... args) throws IllegalAccessException, InvocationTargetException {
        return this.invoke(null, args);
    }

    protected R cast(Object o) {
        return (R)o;
    }

    protected static RuntimeException asRE(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof InvocationTargetException) {
            return VirtualMethod.asRE(e.getCause());
        }
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return new RuntimeException(e);
    }
}

