/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.databene.contiperf.report.LatencyDataSet;
import org.databene.stat.LatencyCounter;

public class GoogleLatencyRenderer {
    public String render(LatencyCounter counter, String title, int width, int height) {
        LatencyDataSet dataset = new LatencyDataSet((int)(counter.maxLatency() - counter.minLatency() + 3L));
        int i = (int)counter.minLatency();
        while ((long)i <= counter.maxLatency()) {
            dataset.addPoint(i, (int)counter.getLatencyCount(i));
            ++i;
        }
        dataset = dataset.reduce(50);
        dataset.addLabel("avg", (int)counter.averageLatency());
        dataset.addLabel("med", (int)counter.percentileLatency(50));
        dataset.addLabel("90%", (int)counter.percentileLatency(90));
        return this.renderDataset(dataset, title, width, height);
    }

    String renderDataset(LatencyDataSet dataset, String title, int width, int height) {
        dataset.scaleY(80);
        try {
            StringBuilder builder = new StringBuilder("http://chart.apis.google.com/chart?cht=lxy");
            builder.append("&chs=").append(width).append('x').append(height);
            GoogleLatencyRenderer.appendData(dataset, builder);
            builder.append("&chxt=x");
            builder.append("&chxr=0,0," + dataset.getMaxX());
            builder.append("&chds=0," + dataset.getMaxX() + ",0,100");
            builder.append("&chf=c,lg,0,FFFFFF,0,FFFF88,1");
            GoogleLatencyRenderer.renderLabels(dataset, builder);
            if (title != null) {
                builder.append("&chtt=" + URLEncoder.encode(title, "UTF-8"));
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding title: " + title, e);
        }
    }

    private static void renderLabels(LatencyDataSet dataset, StringBuilder builder) {
        builder.append("&chm=B,FFE69B,0,0,0");
        for (LatencyDataSet.LabelInfo label : dataset.getLabels()) {
            builder.append("|A" + label.text + ",666666,0," + label.index + ",15");
        }
    }

    private static void appendData(LatencyDataSet dataset, StringBuilder builder) {
        int i;
        builder.append("&chd=t:");
        for (i = 0; i < dataset.pointCount(); ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(dataset.getX(i));
        }
        builder.append('|');
        for (i = 0; i < dataset.pointCount(); ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(dataset.getY(i));
        }
    }
}

