/*
 * Decompiled with CFR 0.152.
 */
package org.databene.stat;

import java.io.PrintWriter;

public final class LatencyCounter {
    private String name;
    private String clockName;
    private int minLatency;
    private int maxLatency;
    private long[] latencyCounts;
    private boolean running;
    private long startTime;
    private long endTime;
    private long sampleCount;
    private long totalLatency;

    public LatencyCounter(String name) {
        this(name, "system", 1000);
    }

    public LatencyCounter(String name, String clockName, int expectedMaxLatency) {
        this.name = name;
        this.clockName = clockName;
        this.latencyCounts = new long[1 + expectedMaxLatency];
        this.sampleCount = 0L;
        this.totalLatency = 0L;
        this.minLatency = -1;
        this.maxLatency = -1;
        this.startTime = -1L;
        this.endTime = -1L;
    }

    public String getName() {
        return this.name;
    }

    public String getClockName() {
        return this.clockName;
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException(this + " has already been started");
        }
        this.startTime = System.currentTimeMillis();
        this.running = true;
    }

    public synchronized void addSample(int latency) {
        if (latency >= this.latencyCounts.length) {
            this.resize(latency);
        }
        int n = latency;
        this.latencyCounts[n] = this.latencyCounts[n] + 1L;
        ++this.sampleCount;
        this.totalLatency += (long)latency;
        if (this.minLatency == -1 || latency < this.minLatency) {
            this.minLatency = latency;
        }
        if (latency > this.maxLatency) {
            this.maxLatency = latency;
        }
    }

    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("Stopping " + this + " which is not running");
        }
        this.running = false;
        this.endTime = System.currentTimeMillis();
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLatencyCount(long latency) {
        if (latency < (long)this.latencyCounts.length) {
            return this.latencyCounts[(int)latency];
        }
        return 0L;
    }

    public long totalLatency() {
        return this.totalLatency;
    }

    public double averageLatency() {
        return (double)this.totalLatency / (double)this.sampleCount;
    }

    public long minLatency() {
        return Math.max(this.minLatency, 0);
    }

    public long maxLatency() {
        return Math.max(this.maxLatency, 0);
    }

    public long sampleCount() {
        return this.sampleCount;
    }

    public long percentileLatency(int percentile) {
        long targetCount = (long)percentile * this.sampleCount / 100L;
        long count = 0L;
        for (long value = this.minLatency(); value <= (long)this.maxLatency; ++value) {
            if ((count += this.getLatencyCount(value)) < targetCount) continue;
            return value;
        }
        return this.maxLatency;
    }

    public double percentileAboveLatency(int latency) {
        long count = 0L;
        for (long value = (long)(latency + 1); value <= (long)this.maxLatency; ++value) {
            count += this.getLatencyCount(value);
        }
        return (double)count * 100.0 / (double)this.sampleCount;
    }

    public double throughput() {
        if (this.startTime == -1L || this.endTime == -1L) {
            throw new IllegalArgumentException("Invalid setup: Use start() and stop() to indicate test start and end!");
        }
        return 1000.0 * (double)this.sampleCount / (double)this.duration();
    }

    public long duration() {
        return this.endTime - this.startTime;
    }

    private void resize(int requestedIndex) {
        int sizingFactor = (requestedIndex + this.latencyCounts.length) / this.latencyCounts.length;
        int newLength = sizingFactor * this.latencyCounts.length;
        long[] newLatencyCounts = new long[newLength];
        System.arraycopy(this.latencyCounts, 0, newLatencyCounts, 0, this.latencyCounts.length);
        this.latencyCounts = newLatencyCounts;
    }

    public void printSummary(PrintWriter out, int ... percentiles) {
        out.println("samples: " + this.sampleCount);
        out.println("max:     " + this.maxLatency());
        out.println("average: " + this.averageLatency());
        out.println("median:  " + this.percentileLatency(50));
        for (int percentile : percentiles) {
            out.println(percentile + "%:     " + this.percentileLatency(percentile));
        }
        out.flush();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

