/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOHelper;
import javax.jdo.spi.I18NHelper;

public class JDOException
extends RuntimeException {
    private static final long serialVersionUID = 1950979275859696534L;
    Throwable[] nested;
    Object failed;
    private static I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private boolean inPrintStackTrace = false;

    public JDOException() {
    }

    public JDOException(String msg) {
        super(msg);
    }

    public JDOException(String msg, Throwable[] nested) {
        super(msg);
        this.nested = nested;
    }

    public JDOException(String msg, Throwable nested) {
        super(msg);
        this.nested = new Throwable[]{nested};
    }

    public JDOException(String msg, Object failed) {
        super(msg);
        this.failed = failed;
    }

    public JDOException(String msg, Throwable[] nested, Object failed) {
        super(msg);
        this.nested = nested;
        this.failed = failed;
    }

    public JDOException(String msg, Throwable nested, Object failed) {
        super(msg);
        this.nested = new Throwable[]{nested};
        this.failed = failed;
    }

    public Object getFailedObject() {
        return this.failed;
    }

    public Throwable[] getNestedExceptions() {
        return this.nested;
    }

    @Override
    public synchronized Throwable getCause() {
        if (this.nested == null || this.nested.length == 0 || this.inPrintStackTrace) {
            return null;
        }
        return this.nested[0];
    }

    @Override
    public Throwable initCause(Throwable cause) {
        throw new JDOFatalInternalException(msg.msg("ERR_CannotInitCause"));
    }

    @Override
    public synchronized String toString() {
        int len = this.nested == null ? 0 : this.nested.length;
        StringBuffer sb = new StringBuffer(10 + 100 * len);
        sb.append(super.toString());
        if (this.failed != null) {
            sb.append("\n").append(msg.msg("MSG_FailedObject"));
            String failedToString = null;
            try {
                failedToString = this.failed.toString();
            }
            catch (Exception ex) {
                Object objectId = JDOHelper.getObjectId(this.failed);
                if (objectId == null) {
                    failedToString = msg.msg("MSG_ExceptionGettingFailedToString", JDOException.exceptionToString(ex));
                }
                String objectIdToString = null;
                try {
                    objectIdToString = objectId.toString();
                }
                catch (Exception ex2) {
                    objectIdToString = JDOException.exceptionToString(ex2);
                }
                failedToString = msg.msg("MSG_ExceptionGettingFailedToStringObjectId", JDOException.exceptionToString(ex), objectIdToString);
            }
            sb.append(failedToString);
        }
        if (len > 0 && !this.inPrintStackTrace) {
            sb.append("\n").append(msg.msg("MSG_NestedThrowables")).append("\n");
            Throwable exception = this.nested[0];
            sb.append(exception == null ? "null" : exception.toString());
            for (int i = 1; i < len; ++i) {
                sb.append("\n");
                exception = this.nested[i];
                sb.append(exception == null ? "null" : exception.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void printStackTrace(PrintStream s) {
        int len = this.nested == null ? 0 : this.nested.length;
        PrintStream printStream = s;
        synchronized (printStream) {
            this.inPrintStackTrace = true;
            super.printStackTrace(s);
            if (len > 0) {
                s.println(msg.msg("MSG_NestedThrowablesStackTrace"));
                for (int i = 0; i < len; ++i) {
                    Throwable exception = this.nested[i];
                    if (exception == null) continue;
                    exception.printStackTrace(s);
                }
            }
            this.inPrintStackTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void printStackTrace(PrintWriter s) {
        int len = this.nested == null ? 0 : this.nested.length;
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            this.inPrintStackTrace = true;
            super.printStackTrace(s);
            if (len > 0) {
                s.println(msg.msg("MSG_NestedThrowablesStackTrace"));
                for (int i = 0; i < len; ++i) {
                    Throwable exception = this.nested[i];
                    if (exception == null) continue;
                    exception.printStackTrace(s);
                }
            }
            this.inPrintStackTrace = false;
        }
    }

    private static String exceptionToString(Exception ex) {
        if (ex == null) {
            return null;
        }
        String s = ex.getClass().getName();
        String message = ex.getMessage();
        return message != null ? s + ": " + message : s;
    }
}

