/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram.internal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.http.HttpResponse;

public class GatekeeperReply
extends HttpResponse {
    private static Log logger = LogFactory.getLog((String)GatekeeperReply.class.getName());
    public int protocolVersion = -1;
    public int status = -1;
    public String jobManagerUrl = null;
    public int failureCode = -1;
    public int jobFailureCode = -1;

    public GatekeeperReply(InputStream in) throws IOException {
        super(in);
        this.charsRead = 1L;
        if (this.contentLength > 0L) {
            this.myparse();
        }
    }

    protected void myparse() throws IOException {
        String line;
        while (this.charsRead < this.contentLength && (line = this.readLine(this.input)).length() != 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)line);
            }
            String tmp = GatekeeperReply.getRest(line.trim());
            if (line.startsWith("protocol-version:")) {
                this.protocolVersion = Integer.parseInt(tmp);
                continue;
            }
            if (line.startsWith("status:")) {
                this.status = Integer.parseInt(tmp);
                continue;
            }
            if (line.startsWith("job-manager-url:")) {
                this.jobManagerUrl = tmp;
                continue;
            }
            if (line.startsWith("failure-code:")) {
                this.failureCode = Integer.parseInt(tmp);
                continue;
            }
            if (!line.startsWith("job-failure-code:")) continue;
            this.jobFailureCode = Integer.parseInt(tmp);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("Protocol-version : " + this.protocolVersion + "\n");
        buf.append("Status           : " + this.status);
        if (this.jobManagerUrl != null) {
            buf.append("\nJob-manager-url  : " + this.jobManagerUrl);
        }
        if (this.failureCode >= 0) {
            buf.append("\nFailure-code     : " + this.failureCode);
        }
        if (this.jobFailureCode >= 0) {
            buf.append("\nJob failure code     : " + this.jobFailureCode);
        }
        return buf.toString();
    }
}

