/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.GlobusGSSName;
import org.globus.util.Util;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GlobusGSSCredentialImpl
implements ExtendedGSSCredential,
Serializable {
    private int usage = 0;
    private GlobusCredential cred;
    private GSSName name;

    public GlobusGSSCredentialImpl() {
        this.cred = null;
        this.name = new GlobusGSSName();
    }

    public GlobusGSSCredentialImpl(GlobusCredential cred, int usage) throws GSSException {
        if (cred == null) {
            throw new IllegalArgumentException("cred == null");
        }
        this.cred = cred;
        this.usage = usage;
        this.name = new GlobusGSSName(cred.getIdentity());
    }

    public int hashCode() {
        if (this.cred == null) {
            return this.usage;
        }
        return this.cred.hashCode() + this.usage;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlobusGSSCredentialImpl) {
            GlobusGSSCredentialImpl other = (GlobusGSSCredentialImpl)obj;
            return other.usage == this.usage && other.cred == this.cred;
        }
        return false;
    }

    public void dispose() throws GSSException {
        this.cred = null;
    }

    public GSSName getName() throws GSSException {
        return this.name;
    }

    public GSSName getName(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        return this.name;
    }

    public void add(GSSName aName, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
        throw new GSSException(16);
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        return this.usage;
    }

    public int getRemainingLifetime() throws GSSException {
        return this.cred == null ? -1 : (int)this.cred.getTimeLeft();
    }

    public int getRemainingInitLifetime(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (this.usage == 1 || this.usage == 0) {
            return this.getRemainingLifetime();
        }
        throw new GSSException(11);
    }

    public int getRemainingAcceptLifetime(Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (this.usage == 2 || this.usage == 0) {
            return this.getRemainingLifetime();
        }
        throw new GSSException(11);
    }

    public Oid[] getMechs() throws GSSException {
        return GlobusGSSManagerImpl.MECHS;
    }

    public byte[] export(int option) throws GSSException {
        return this.export(option, null);
    }

    public byte[] export(int option, Oid mech) throws GSSException {
        GlobusGSSManagerImpl.checkMechanism(mech);
        if (this.cred == null) {
            throw new GlobusGSSException(11, 27, "anonCred00");
        }
        switch (option) {
            case 0: {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    this.cred.save(bout);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                return bout.toByteArray();
            }
            case 1: {
                File file = null;
                FileOutputStream fout = null;
                try {
                    file = File.createTempFile("x509up_", ".tmp");
                    Util.setOwnerAccessOnly(file.getAbsolutePath());
                    fout = new FileOutputStream(file);
                    this.cred.save(fout);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                finally {
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (Exception e) {}
                    }
                }
                String handle = "X509_USER_PROXY=" + file.getAbsolutePath();
                return handle.getBytes();
            }
        }
        throw new GlobusGSSException(11, 7, "unknownOption", new Object[]{new Integer(option)});
    }

    public Object inquireByOid(Oid oid) throws GSSException {
        if (oid == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (oid.equals(GSSConstants.X509_CERT_CHAIN)) {
            return this.cred == null ? null : this.cred.getCertificateChain();
        }
        return null;
    }

    public GlobusCredential getGlobusCredential() {
        return this.cred;
    }

    public PrivateKey getPrivateKey() {
        return this.cred == null ? null : this.cred.getPrivateKey();
    }

    public X509Certificate[] getCertificateChain() {
        return this.cred == null ? null : this.cred.getCertificateChain();
    }
}

