/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.exception.FTPException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.io.streams.FTPInputStream;
import org.ietf.jgss.GSSCredential;

public class GridFTPInputStream
extends FTPInputStream {
    public GridFTPInputStream(GSSCredential cred, String host, int port, String file) throws IOException, FTPException {
        this(cred, HostAuthorization.getInstance(), host, port, file, true, 1, true, true);
    }

    public GridFTPInputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean reqDCAU) throws IOException, FTPException {
        this(cred, auth, host, port, file, true, 1, reqDCAU, true);
    }

    public GridFTPInputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean reqDCAU, boolean useGFD47) throws IOException, FTPException {
        this(cred, auth, host, port, file, true, 1, reqDCAU, useGFD47);
    }

    public GridFTPInputStream(GSSCredential cred, Authorization auth, String host, int port, String file, boolean passive, int type, boolean reqDCAU, boolean useGFD47) throws IOException, FTPException {
        GridFTPClient gridFtp = new GridFTPClient(host, port);
        gridFtp.setAuthorization(auth);
        gridFtp.authenticate(cred);
        boolean bl = this.useGFD47 = useGFD47 && gridFtp.isFeatureSupported("GETPUT");
        if (gridFtp.isFeatureSupported("DCAU")) {
            if (!reqDCAU) {
                gridFtp.setDataChannelAuthentication(DataChannelAuthentication.NONE);
            }
        } else {
            gridFtp.setLocalNoDataChannelAuthentication();
        }
        this.ftp = gridFtp;
        this.get(passive, type, file);
    }
}

