/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.globus.common.CoGProperties;
import org.globus.common.Version;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.myproxy.ChangePasswordParams;
import org.globus.myproxy.CredentialInfo;
import org.globus.myproxy.DestroyParams;
import org.globus.myproxy.GetParams;
import org.globus.myproxy.GetTrustrootsParams;
import org.globus.myproxy.InfoParams;
import org.globus.myproxy.InitParams;
import org.globus.myproxy.StoreParams;
import org.globus.util.Util;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class MyProxy {
    public static final int MYPROXY_SERVER_PORT = 7512;
    public static final int PORTAL_LIFETIME_HOURS = 12;
    public static final int CRED_LIFETIME_HOURS = 168;
    public static final int MATCH_CN_ONLY = 0;
    public static final int REGULAR_EXP = 1;
    private static final String commonOptions = "\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n";
    private static final String message = "\nSyntax: java MyProxy [common options] command [command options]\n        java MyProxy -version\n        java MyProxy -help\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommands:\n\t put            - put proxy\n\t store          - store credentials\n\t get            - get proxy\n\t anonget        - get proxy without local credentials\n\t get-trustroots - get trustroots information\n\t destroy        - remove proxy\n\t info           - credential information\n\t pwd            - change credential password\n\n\tSpecify -help after a command name for command-specific help.\n";
    private static final String destroyMessage = "\nSyntax: java MyProxy [common options] destroy [command options]\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommand Options:\n\t-help\n\t\tDisplays usage\n\t-k | -credname <name>\n\t\tSpecifies credential name\n";
    private static final String pwdMessage = "\nSyntax: java MyProxy [common options] pwd [command options]\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommand Options:\n\t-help\n\t\tDisplays usage\n\t-k | -credname <name>\n\t\tSpecifies credential name\n";
    private static final String infoMessage = "\nSyntax: java MyProxy [common options] info [command options]\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommand Options:\n\t-help\n\t\tDisplays usage\n";
    private static final String getMessage = "\nSyntax: java MyProxy [common options] [get|anonget] [command options]\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommand Options:\n\t-help\n\t\tDisplays usage\n\t-t <hours> | -portal_lifetime <hours>\n\t\tLifetime of delegated proxy on\n\t\tthe portal (default 12 hours)\n\t-o | -out <path>\n\t\tLocation of delegated proxy\n\t-T | -trustroots\n\t\tManage trust roots\n\t-k | -credname <name>\n\t\tSpecifies credential name\n\t-a | -authorization <path>\n\t\tSpecifies path to credentials to renew\n";
    private static final String putMessage = "\nSyntax: java MyProxy [common options] put [command options]\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommand Options:\n\t-help\n\t\tDisplays usage\n\t-cert <certfile>\n\t\tNon-standard location of user certificate\n\t-key <keyfile>\n\t\tNon-standard location of user key\n\t-t <hours> | -portal_lifetime <hours>\n\t\tLifetime of delegated proxy on\n\t\tthe portal (default 12 hours)\n\t-c <hours> | -cred_lifetime <hours> \n\t\tLifetime of delegated proxy\n\t\t(default 1 week - 168 hours)\n\t-a | -allow_anonymous_retrievers\n\t\tAllow credentials to be retrieved with just username/passphrase\n\t-A | -allow_anonymous_renewers\n\t\tAllow credentials to be renewed by any client (not recommended)\n\t-r | -retrievable_by <dn>\n\t\tAllow specified entity to retrieve credential\n\t-R | -renewable_by <dn>\n\t\tAllow specified entity to renew credential\n\t-x | -regex_dn_match\n\t\tSpecifies that the DN used by  options -r and -R\n\t\twill be matched as a regular expression\n \t-X | -match_cn_only\n\t\tSpecifies  that  the  DN  used by options -r and -R\n\t\twill be matched against the Common Name (CN) of the\n\t\tsubject\n\t-n | -no_passphrase\n\t\tDisable passphrase authentication\n\t-k | -credname <name>\n\t\tSpecifies credential name\n\t-K | -creddesc <desc>\n\t\tSpecifies credential description\n";
    private static final String storeMessage = "\nSyntax: java MyProxy [common options] store [command options]\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommand Options:\n\t-help\n\t\tDisplays usage\n\t-cert <certfile>\n\t\tNon-standard location of user certificate\n\t-key <keyfile>\n\t\tNon-standard location of user key\n\t-t <hours> | -portal_lifetime <hours>\n\t\tLifetime of delegated proxy on\n\t\tthe portal (default 12 hours)\n\t-a | -allow_anonymous_retrievers\n\t\tAllow credentials to be retrieved with just username/passphrase\n\t-A | -allow_anonymous_renewers\n\t\tAllow credentials to be renewed by any client (not recommended)\n\t-r | -retrievable_by <dn>\n\t\tAllow specified entity to retrieve credential\n\t-R | -renewable_by <dn>\n\t\tAllow specified entity to renew credential\n\t-x | -regex_dn_match\n\t\tSpecifies that the DN used by  options -r and -R\n\t\twill be matched as a regular expression\n \t-X | -match_cn_only\n\t\tSpecifies  that  the  DN  used by options -r and -R\n\t\twill be matched against the Common Name (CN) of the\n\t\tsubject\n\t-k | -credname <name>\n\t\tSpecifies credential name\n\t-K | -creddesc <desc>\n\t\tSpecifies credential description\n";
    private static final String getTrustrootsMessage = "\nSyntax: java MyProxy [common options] get-trustroots [command options]\n\n\tCommon Options:\n\t-help\n\t\tDisplays usage\n\t-v | -version\n\t\tDisplays version\n\n\t-h <host> | -host <host>\n\t\tHostname of the myproxy-server\n\t-p <port> | -port <port>\n\t\tPort of the myproxy-server\n\t\t(default 7512)\n\t-s <subject> | -subject <subject>\n\t\tPerforms subject authorization\n\t-l <username> | -username <username>\n\t\tUsername for the delegated proxy\n\t-d | -dn_as_username\n\t\tUse the proxy certificate subject (DN) as the default\n\t\tusername instead of the \"user.name\" system property.\n\t-S | -stdin_pass\n\t\tAllows passphrase from stdin.\n\n\tCommand Options:\n\t-help\n\t\tDisplays usage\n";
    private int port = 7512;
    private String hostname;
    private String username;
    private String subjectDN;
    private boolean debug = false;
    private boolean dnAsUsername = false;
    private boolean stdin = false;
    private boolean wantTrustroots = false;

    protected void parseCmdLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                CertUtil.init();
                if (args[i].equalsIgnoreCase("get")) {
                    this.doGet(args, i + 1, false);
                    continue;
                }
                if (args[i].equalsIgnoreCase("anonget")) {
                    this.doGet(args, i + 1, true);
                    continue;
                }
                if (args[i].equalsIgnoreCase("get-trustroots")) {
                    this.doGetTrustroots(args, i + 1, true);
                    continue;
                }
                if (args[i].equalsIgnoreCase("put")) {
                    this.doPut(args, i + 1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("store")) {
                    this.doStore(args, i + 1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("destroy")) {
                    this.doDestroy(args, i + 1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("info")) {
                    this.doInfo(args, i + 1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("pwd")) {
                    this.doChangePassword(args, i + 1);
                    continue;
                }
                MyProxy.error("Error: unknown command (" + args[i] + ")");
                continue;
            }
            if (args[i].equals("-h") || args[i].equalsIgnoreCase("-host")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -h requires hostname");
                    continue;
                }
                this.hostname = args[i];
                continue;
            }
            if (args[i].equals("-p") || args[i].equalsIgnoreCase("-port")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -p requires port number");
                    continue;
                }
                this.port = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-l") || args[i].equalsIgnoreCase("-username")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -l requires username");
                    continue;
                }
                this.username = args[i];
                continue;
            }
            if (args[i].equals("-d") || args[i].equalsIgnoreCase("-dn_as_username")) {
                this.dnAsUsername = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equals("-S") || args[i].equalsIgnoreCase("-stdin_pass")) {
                this.stdin = true;
                continue;
            }
            if (args[i].equals("-s") || args[i].equalsIgnoreCase("-subject")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -subject requires an argument");
                    continue;
                }
                this.subjectDN = args[i];
                continue;
            }
            if (args[i].equals("-v") || args[i].equalsIgnoreCase("-version")) {
                System.out.println(Version.getVersion());
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(message);
                System.exit(1);
                continue;
            }
            MyProxy.error("Error: argument #" + i + " (" + args[i] + ") : unknown");
        }
        MyProxy.error("Error: No command specified");
    }

    private String getUsername() {
        if (this.dnAsUsername) {
            GSSCredential cred = MyProxy.getDefaultCredential();
            try {
                return ((Object)cred.getName()).toString();
            }
            catch (Exception e) {
                this.exit("Failed to get credential name: " + e.getMessage(), e);
            }
        }
        if (this.username == null) {
            return System.getProperty("user.name");
        }
        return this.username;
    }

    private void verifyCommonCmdLine() {
        if (this.hostname == null) {
            MyProxy.error("Error: myproxy-server hostname not specified");
        }
    }

    private org.globus.myproxy.MyProxy getMyProxy() {
        org.globus.myproxy.MyProxy myProxy = new org.globus.myproxy.MyProxy(this.hostname, this.port);
        if (this.subjectDN != null) {
            myProxy.setAuthorization(new IdentityAuthorization(this.subjectDN));
        }
        return myProxy;
    }

    protected void doInfo(String[] args, int start) {
        for (int i = start; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(infoMessage);
                System.exit(1);
                continue;
            }
            MyProxy.error("Error: info argument #" + i + " (" + args[i] + ") : unknown");
        }
        this.verifyCommonCmdLine();
        GSSCredential credential = MyProxy.getDefaultCredential();
        InfoParams infoRequest = new InfoParams();
        infoRequest.setUserName(this.getUsername());
        infoRequest.setPassphrase("DUMMY-PASSPHRASE");
        try {
            CredentialInfo[] info = this.getMyProxy().info(credential, infoRequest);
            System.out.println("Owner: " + info[0].getOwner());
            for (int i = 0; i < info.length; ++i) {
                String tmp = info[i].getName();
                System.out.println(tmp == null ? "default:" : tmp + ":");
                System.out.println("\tStart Time  : " + info[i].getStartTime());
                System.out.println("\tEnd Time    : " + info[i].getEndTime());
                long now = System.currentTimeMillis();
                if (info[i].getEndTime() > now) {
                    System.out.println("\tTime left   : " + Util.formatTimeSec((info[i].getEndTime() - now) / 1000L));
                } else {
                    System.out.println("\tTime left   : expired");
                }
                tmp = info[i].getRetrievers();
                if (tmp != null) {
                    System.out.println("\tRetrievers  : " + tmp);
                }
                if ((tmp = info[i].getRenewers()) != null) {
                    System.out.println("\tRenewers    : " + tmp);
                }
                if ((tmp = info[i].getDescription()) == null) continue;
                System.out.println("\tDescription : " + tmp);
            }
        }
        catch (Exception e) {
            this.exit("Error: " + e.getMessage(), e);
        }
        this.exit();
    }

    protected void doDestroy(String[] args, int start) {
        String credName = null;
        for (int i = start; i < args.length; ++i) {
            if (args[i].equals("-k") || args[i].equalsIgnoreCase("-credname")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -k requires credential name");
                    continue;
                }
                credName = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(destroyMessage);
                System.exit(1);
                continue;
            }
            MyProxy.error("Error: destroy argument #" + i + " (" + args[i] + ") : unknown");
        }
        this.verifyCommonCmdLine();
        GSSCredential credential = MyProxy.getDefaultCredential();
        DestroyParams destroyRequest = new DestroyParams();
        destroyRequest.setUserName(this.getUsername());
        destroyRequest.setCredentialName(credName);
        destroyRequest.setPassphrase("DUMMY-PASSPHRASE");
        try {
            this.getMyProxy().destroy(credential, destroyRequest);
            System.out.println("A proxy was succesfully destroyed for user " + this.getUsername() + ".");
        }
        catch (Exception e) {
            this.exit("Error: " + e.getMessage(), e);
        }
        this.exit();
    }

    protected void doChangePassword(String[] args, int start) {
        String password;
        String credName = null;
        for (int i = start; i < args.length; ++i) {
            if (args[i].equals("-k") || args[i].equalsIgnoreCase("-credname")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -k requires credential name");
                    continue;
                }
                credName = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(pwdMessage);
                System.exit(1);
                continue;
            }
            MyProxy.error("Error: pwd argument #" + i + " (" + args[i] + ") : unknown");
        }
        this.verifyCommonCmdLine();
        GSSCredential credential = MyProxy.getDefaultCredential();
        ChangePasswordParams request = new ChangePasswordParams();
        request.setUserName(this.getUsername());
        request.setCredentialName(credName);
        String prompt1 = "Enter credential pass phrase: ";
        String string = password = this.stdin ? Util.getInput(prompt1) : Util.getPrivateInput(prompt1);
        if (password == null) {
            return;
        }
        request.setPassphrase(password);
        String prompt2 = "Enter new pass phrase: ";
        String string2 = password = this.stdin ? Util.getInput(prompt2) : Util.getPrivateInput(prompt2);
        if (password == null) {
            return;
        }
        request.setNewPassphrase(password);
        try {
            this.getMyProxy().changePassword(credential, request);
            System.out.println("Password changed successfully.");
        }
        catch (Exception e) {
            this.exit("Error: " + e.getMessage(), e);
        }
        this.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(String[] args, int start, boolean anonymous) {
        String credName = null;
        int lifetime = 43200;
        String outputFile = null;
        GlobusGSSCredentialImpl authzcreds = null;
        for (int i = start; i < args.length; ++i) {
            if (args[i].equals("-k") || args[i].equalsIgnoreCase("-credname")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -k requires credential name");
                    continue;
                }
                credName = args[i];
                continue;
            }
            if (args[i].equals("-o") || args[i].equalsIgnoreCase("-out")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -o requires an argument");
                    continue;
                }
                outputFile = args[i];
                continue;
            }
            if (args[i].equals("-t") || args[i].equalsIgnoreCase("-portal_lifetime")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -t requires time argument in hours");
                    continue;
                }
                lifetime = Integer.parseInt(args[i]) * 3600;
                continue;
            }
            if (args[i].equals("-a") || args[i].equalsIgnoreCase("-authorization")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -a requires an argument");
                    continue;
                }
                try {
                    GlobusCredential pkiCred = new GlobusCredential(args[i]);
                    authzcreds = new GlobusGSSCredentialImpl(pkiCred, 1);
                }
                catch (Exception e) {
                    this.exit("Failed to load credentials at " + args[i] + ": " + e.getMessage(), e);
                }
                continue;
            }
            if (args[i].equals("-T") || args[i].equalsIgnoreCase("-trustroots")) {
                this.wantTrustroots = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(getMessage);
                System.exit(1);
                continue;
            }
            MyProxy.error("Error: get argument #" + i + " (" + args[i] + ") : unknown");
        }
        this.verifyCommonCmdLine();
        GSSCredential credential = null;
        if (!anonymous) {
            credential = MyProxy.getDefaultCredential();
        }
        GetParams getRequest = new GetParams();
        getRequest.setUserName(this.getUsername());
        getRequest.setCredentialName(credName);
        getRequest.setLifetime(lifetime);
        getRequest.setWantTrustroots(this.wantTrustroots);
        if (authzcreds == null) {
            String password;
            String prompt = "Enter MyProxy Pass Phrase: ";
            String string = password = this.stdin ? Util.getInput(prompt) : Util.getPrivateInput(prompt);
            if (password == null) {
                return;
            }
            getRequest.setPassphrase(password);
        } else {
            getRequest.setAuthzCreds(authzcreds);
        }
        try {
            org.globus.myproxy.MyProxy myProxy = this.getMyProxy();
            if (this.wantTrustroots) {
                this.bootstrapIfNeeded(myProxy);
            }
            GSSCredential newCred = myProxy.get(credential, getRequest);
            if (this.debug) {
                String subject = ((Object)newCred.getName()).toString();
                System.out.println("Proxy subject name: " + subject);
            }
            if (outputFile == null) {
                CoGProperties properties = CoGProperties.getDefault();
                outputFile = properties.getProxyFile();
            }
            File f = null;
            f = outputFile != null ? new File(outputFile) : File.createTempFile("x509up_", ".pem", new File("."));
            String path = f.getPath();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(path);
                Util.setOwnerAccessOnly(path);
                byte[] data = ((ExtendedGSSCredential)newCred).export(0);
                ((OutputStream)out).write(data);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Exception e) {}
                }
            }
            System.out.println("A proxy has been received for user " + this.getUsername() + " in " + path);
            if (this.wantTrustroots) {
                if (myProxy.writeTrustRoots()) {
                    System.out.println("Wrote trust roots to " + myProxy.getTrustRootPath() + ".");
                } else {
                    System.out.println("Received no trust roots from MyProxy server.");
                }
            }
        }
        catch (Exception e) {
            this.exit("Error: " + e.getMessage(), e);
        }
        this.exit();
    }

    protected void doPut(String[] args, int start) {
        this.doPutOrStore(args, start, false);
    }

    protected void doStore(String[] args, int start) {
        this.doPutOrStore(args, start, true);
    }

    protected void doPutOrStore(String[] args, int start, boolean storeKey) {
        String userCertFile = null;
        String userKeyFile = null;
        String credName = null;
        String credDesc = null;
        int lifetime = 43200;
        int credLifetime = 604800;
        boolean exprType = false;
        String retrievers = null;
        String renewers = null;
        boolean anonRetrievers = false;
        boolean anonRenewers = false;
        boolean useEmptyPwd = false;
        X509Certificate[] userCerts = null;
        BouncyCastleOpenSSLKey userKey = null;
        for (int i = start; i < args.length; ++i) {
            if (args[i].equals("-k") || args[i].equalsIgnoreCase("-credname")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -k requires credential name");
                    continue;
                }
                credName = args[i];
                continue;
            }
            if (args[i].equals("-K") || args[i].equalsIgnoreCase("-creddesc")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -K requires credential description");
                    continue;
                }
                credDesc = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-cert")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -cert requires filename argument");
                    continue;
                }
                userCertFile = args[i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-key")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -key requires filename argument");
                    continue;
                }
                userKeyFile = args[i];
                continue;
            }
            if (args[i].equals("-t") || args[i].equalsIgnoreCase("-portal_lifetime")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -t requires time argument in hours");
                    continue;
                }
                lifetime = Integer.parseInt(args[i]) * 3600;
                continue;
            }
            if (!storeKey && (args[i].equals("-c") || args[i].equalsIgnoreCase("-cred_lifetime"))) {
                if (++i == args.length) {
                    MyProxy.error("Error: -c requires time argument in hours");
                    continue;
                }
                credLifetime = Integer.parseInt(args[i]) * 3600;
                continue;
            }
            if (args[i].equals("-x") || args[i].equalsIgnoreCase("-regex_dn_match")) {
                exprType = true;
                continue;
            }
            if (args[i].equals("-X") || args[i].equalsIgnoreCase("-match_cn_only")) {
                exprType = false;
                continue;
            }
            if (args[i].equals("-A") || args[i].equalsIgnoreCase("-allow_anonymous_renewers")) {
                anonRenewers = true;
                continue;
            }
            if (args[i].equals("-a") || args[i].equalsIgnoreCase("-allow_anonymous_retrievers")) {
                anonRetrievers = true;
                continue;
            }
            if (args[i].equals("-r") || args[i].equalsIgnoreCase("-retrievable_by")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -r requires dn argument");
                    continue;
                }
                if (retrievers == null) {
                    retrievers = args[i];
                    useEmptyPwd = true;
                    continue;
                }
                MyProxy.error("-r already specified.");
                continue;
            }
            if (args[i].equals("-R") || args[i].equalsIgnoreCase("-renewable_by")) {
                if (++i == args.length) {
                    MyProxy.error("Error: -R requires dn argument");
                    continue;
                }
                if (renewers == null) {
                    renewers = args[i];
                    continue;
                }
                MyProxy.error("-R already specified.");
                continue;
            }
            if (!storeKey && (args[i].equals("-n") || args[i].equalsIgnoreCase("-no_passphrase"))) {
                useEmptyPwd = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                if (storeKey) {
                    System.err.println(storeMessage);
                } else {
                    System.err.println(putMessage);
                }
                System.exit(1);
                continue;
            }
            MyProxy.error("Error: put argument #" + i + " (" + args[i] + ") : unknown");
        }
        this.verifyCommonCmdLine();
        CoGProperties properties = CoGProperties.getDefault();
        if (userKeyFile == null) {
            userKeyFile = properties.getUserKeyFile();
        }
        if (userCertFile == null) {
            userCertFile = properties.getUserCertFile();
        }
        if (renewers != null) {
            if (retrievers != null || anonRetrievers) {
                MyProxy.error("Error: -R in incompatible with -a and -r.");
            }
            if (anonRenewers) {
                MyProxy.error("Error: Only one -A or -R option may be specified.");
            }
        }
        if (retrievers != null) {
            if (renewers != null || anonRenewers) {
                MyProxy.error("Error: -r is incompatible with -A and -R.");
            }
            if (anonRetrievers) {
                MyProxy.error("Error: Only one -a or -r option may be specified.");
            }
            if (useEmptyPwd) {
                MyProxy.error("Error: -r in incompatible with -n. A passphrase is required for credential retrieval.");
            }
        }
        if (anonRetrievers) {
            if (anonRenewers || renewers != null) {
                MyProxy.error("Error: -a is incompatible with -A and -R.");
            }
            if (useEmptyPwd) {
                MyProxy.error("Error: -a is incompatible with -n. A passphrase is required for credential retrieval.");
            }
        }
        if (anonRenewers && (anonRetrievers || retrievers != null)) {
            MyProxy.error("Error: -A is incompatible with -a and -r.");
        }
        if (retrievers != null && !exprType) {
            retrievers = "*/CN=" + retrievers;
        } else if (anonRetrievers) {
            retrievers = "*";
        }
        if (renewers != null && !exprType) {
            renewers = "*/CN=" + renewers;
        } else if (anonRenewers) {
            renewers = "*";
        }
        if (storeKey) {
            StoreParams storeRequest = new StoreParams();
            storeRequest.setUserName(this.getUsername());
            storeRequest.setLifetime(lifetime);
            storeRequest.setCredentialName(credName);
            storeRequest.setCredentialDescription(credDesc);
            storeRequest.setRenewer(renewers);
            storeRequest.setRetriever(retrievers);
            try {
                userKey = new BouncyCastleOpenSSLKey(userKeyFile);
            }
            catch (IOException e) {
                this.exit("Error: Failed to load key: " + userKeyFile, e);
            }
            catch (GeneralSecurityException e) {
                this.exit("Error: Unable to load key: " + e.getMessage(), e);
            }
            try {
                userCerts = CertUtil.loadCertificates(userCertFile);
            }
            catch (IOException e) {
                this.exit("Error: Failed to load certificate: " + userCertFile, e);
            }
            catch (GeneralSecurityException e) {
                this.exit("Error: Unable to load certificate: " + e.getMessage(), e);
            }
            GSSCredential credential = MyProxy.getDefaultCredential();
            try {
                this.getMyProxy().store(credential, userCerts, userKey, storeRequest);
                System.out.println("Credentials saved to MyProxy server on " + this.hostname + ".");
            }
            catch (Exception e) {
                this.exit("Error: " + e.getMessage(), e);
            }
        } else {
            GSSCredential credential = MyProxy.createNewProxy(userCertFile, userKeyFile, credLifetime, this.stdin);
            InitParams initRequest = new InitParams();
            initRequest.setUserName(this.getUsername());
            initRequest.setLifetime(lifetime);
            initRequest.setCredentialName(credName);
            initRequest.setCredentialDescription(credDesc);
            initRequest.setRenewer(renewers);
            initRequest.setRetriever(retrievers);
            if (!useEmptyPwd) {
                String password;
                String prompt = "Enter MyProxy Pass Phrase: ";
                String string = password = this.stdin ? Util.getInput(prompt) : Util.getPrivateInput(prompt);
                if (password == null) {
                    return;
                }
                initRequest.setPassphrase(password);
            }
            try {
                this.getMyProxy().put(credential, initRequest);
                System.out.println("A proxy valid for " + credLifetime / 3600 + " hours (" + credLifetime / 86400 + " days) for user " + this.getUsername() + " now exists on " + this.hostname + ".");
            }
            catch (Exception e) {
                this.exit("Error: " + e.getMessage(), e);
            }
        }
        this.exit();
    }

    protected void doGetTrustroots(String[] args, int start, boolean anonymous) {
        Object outputFile = null;
        for (int i = start; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(getTrustrootsMessage);
                System.exit(1);
                continue;
            }
            MyProxy.error("Error: get argument #" + i + " (" + args[i] + ") : unknown");
        }
        this.verifyCommonCmdLine();
        GSSCredential credential = null;
        if (!anonymous) {
            credential = MyProxy.getDefaultCredential();
        }
        GetTrustrootsParams getTrustrootsRequest = new GetTrustrootsParams();
        try {
            org.globus.myproxy.MyProxy myProxy = this.getMyProxy();
            this.bootstrapIfNeeded(myProxy);
            myProxy.getTrustroots(credential, getTrustrootsRequest);
            if (myProxy.writeTrustRoots()) {
                System.out.println("Wrote trust roots to " + myProxy.getTrustRootPath() + ".");
            } else {
                System.out.println("Received no trust roots from MyProxy server.");
            }
        }
        catch (Exception e) {
            this.exit("Error: " + e.getMessage(), e);
        }
        this.exit();
    }

    private void bootstrapIfNeeded(org.globus.myproxy.MyProxy myProxy) {
        if (!new File(myProxy.getTrustRootPath()).exists()) {
            System.out.println("Bootstrapping MyProxy server root of trust.");
            try {
                myProxy.bootstrapTrust();
            }
            catch (Exception e) {
                System.err.println("MyProxy bootstrapTrust failed: " + e);
            }
        }
    }

    private void exit() {
        System.exit(0);
    }

    private void exit(String msg, Exception e) {
        System.err.println(msg);
        if (this.debug) {
            e.printStackTrace();
        }
        System.exit(-1);
    }

    private static void error(String msg) {
        System.err.println(msg);
        MyProxy.displaySyntax();
    }

    private static void displaySyntax() {
        System.err.println("\nSyntax : java MyProxy [-help] command [-help]");
        System.err.println();
        System.err.println("Use -help to display full usage.");
        System.exit(1);
    }

    public static void main(String[] args) {
        MyProxy myProxy = new MyProxy();
        myProxy.parseCmdLine(args);
    }

    private static GSSCredential getDefaultCredential() {
        GSSManager manager = ExtendedGSSManager.getInstance();
        try {
            return manager.createCredential(1);
        }
        catch (GSSException e) {
            System.err.println("Failed to load default credentials: " + e.getMessage());
            System.exit(-1);
            return null;
        }
    }

    private static GSSCredential createNewProxy(String userCertFile, String userKeyFile, int lifetime, boolean stdin) {
        X509Certificate[] userCerts = null;
        PrivateKey userKey = null;
        try {
            BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(userKeyFile);
            if (key.isEncrypted()) {
                String pwd;
                String prompt = "Enter GRID pass phrase: ";
                String string = pwd = stdin ? Util.getInput(prompt) : Util.getPrivateInput(prompt);
                if (pwd == null) {
                    System.exit(-1);
                }
                key.decrypt(pwd);
            }
            userKey = key.getPrivateKey();
        }
        catch (IOException e) {
            System.err.println("Error: Failed to load key: " + userKeyFile);
            System.exit(-1);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error: Wrong pass phrase");
            System.exit(-1);
        }
        try {
            userCerts = CertUtil.loadCertificates(userCertFile);
        }
        catch (IOException e) {
            System.err.println("Error: Failed to load cert: " + userCertFile);
            System.exit(-1);
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error: Unable to load user certificate: " + e.getMessage());
            System.exit(-1);
        }
        BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
        int bits = 1024;
        boolean limited = false;
        int proxyType = limited ? 2 : 3;
        try {
            GlobusCredential proxy = factory.createCredential(userCerts, userKey, bits, lifetime, proxyType);
            return new GlobusGSSCredentialImpl(proxy, 1);
        }
        catch (Exception e) {
            System.err.println("Failed to create a proxy: " + e.getMessage());
            System.exit(-1);
            return null;
        }
    }
}

