/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.iterators.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.dmfs.iterators.EmptyIterator;
import org.dmfs.iterators.SingletonIterator;
import org.dmfs.iterators.decorators.Filtered;
import org.dmfs.iterators.decorators.Serialized;
import org.dmfs.iterators.elementary.Seq;
import org.dmfs.iterators.filters.NonNull;

public final class SlimSet<E>
implements Set<E>,
Cloneable {
    private boolean mContainsNull;
    private int mSize;
    private Object[] mArray;
    private int mHashCode;
    private final float mLoadFactor;

    public SlimSet() {
        this(16);
    }

    public SlimSet(int size) {
        this(size, 0.75f);
    }

    public SlimSet(int size, float foadFactor) {
        this(new Object[(int)Math.max((float)size / foadFactor, 16.0f)], 0, false, 0, foadFactor);
    }

    public SlimSet(Collection<E> other) {
        this(other.size() * 3 / 2);
        this.addAll(other);
    }

    public SlimSet(E[] values) {
        this(values.length * 3 / 2);
        for (E value : values) {
            this.add(value);
        }
    }

    private SlimSet(Object[] objects, int size, boolean containsNull, int hash, float lf) {
        if (lf <= 0.0f || lf >= 1.0f) {
            throw new IllegalArgumentException(String.format("The load factor %f is not a number between 0 and 1", Float.valueOf(lf)));
        }
        this.mArray = objects;
        this.mSize = size;
        this.mContainsNull = containsNull;
        this.mHashCode = hash;
        this.mLoadFactor = lf;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return this.mContainsNull;
        }
        return this.mArray[SlimSet.predictedPosition(this.mArray, object, object.hashCode())] != null;
    }

    @Override
    public boolean add(E object) {
        int hash;
        int i;
        if (object == null) {
            if (this.mContainsNull) {
                return false;
            }
            ++this.mSize;
            this.mContainsNull = true;
            return true;
        }
        if ((float)this.mArray.length * this.mLoadFactor <= (float)this.mSize) {
            this.mArray = SlimSet.rehash(this.mArray, this.mArray.length * 2);
        }
        if (this.mArray[i = SlimSet.predictedPosition(this.mArray, object, hash = object.hashCode())] != null) {
            return false;
        }
        this.mArray[i] = object;
        ++this.mSize;
        this.mHashCode ^= hash;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.mSize == 0;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    private static Object[] rehash(Object[] values, int newSize) {
        Object[] newArray = new Object[newSize];
        for (Object value : values) {
            if (value == null) continue;
            newArray[SlimSet.predictedPosition((Object[])newArray, (Object)value, (int)value.hashCode())] = value;
        }
        return newArray;
    }

    private static int predictedPosition(Object[] array, Object object, int hash) {
        int arraySize = array.length;
        int i = Math.abs(hash) % arraySize;
        Object element = array[i];
        while (element != null) {
            if (element.equals(object)) {
                return i;
            }
            i = (i + 1) % arraySize;
            element = array[i];
        }
        return i;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c instanceof Set && c.size() * 4 > this.size() * 3) {
            this.mArray = SlimSet.rehash(this.mArray, (int)((float)c.size() / this.mLoadFactor) + this.size());
        }
        boolean result = false;
        for (E element : c) {
            result |= this.add(element);
        }
        return result;
    }

    @Override
    public void clear() {
        this.mArray = new Object[this.mArray.length];
        this.mSize = 0;
        this.mContainsNull = false;
        this.mHashCode = 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object element : c) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.mSize == 0) {
            return EmptyIterator.instance();
        }
        if (this.mSize == 1 && this.mContainsNull) {
            return new SingletonIterator<Object>(null);
        }
        Filtered<Object> result = new Filtered<Object>(new Seq<Object>((Object[])this.mArray.clone()), NonNull.instance());
        if (this.mContainsNull) {
            return new Serialized(result, new SingletonIterator<Object>(null));
        }
        return result;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            if (!this.mContainsNull) {
                return false;
            }
            --this.mSize;
            this.mContainsNull = true;
            return true;
        }
        int hash = object.hashCode();
        int i = SlimSet.predictedPosition(this.mArray, object, hash);
        if (this.mArray[i] == null) {
            return false;
        }
        this.mHashCode ^= hash;
        this.mArray[i] = null;
        --this.mSize;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object element : c) {
            result |= this.remove(element);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int originalCount = this.mSize--;
        if (this.mContainsNull && !c.contains(null)) {
            this.mContainsNull = false;
        }
        for (Object element : this.mArray) {
            if (element == null || c.contains(element)) continue;
            this.mHashCode ^= element.hashCode();
            this.mArray[i] = null;
            --this.mSize;
        }
        return this.mSize != originalCount;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.mArray.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        System.arraycopy(this.mArray, 0, a, 0, Math.min(a.length, this.mArray.length));
        return a;
    }

    protected SlimSet<E> clone() {
        return new SlimSet<E>((Object[])this.mArray.clone(), this.mSize, this.mContainsNull, this.mHashCode, this.mLoadFactor);
    }

    @Override
    public int hashCode() {
        return this.mContainsNull ? this.mHashCode ^ 0x74CBB1 : this.mHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        if (obj instanceof SlimSet && obj.hashCode() != this.hashCode()) {
            return false;
        }
        Set other = (Set)obj;
        return other.size() == this.mSize && other.containsAll(this);
    }
}

