/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.optional.decorators;

import java.util.NoSuchElementException;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.predicate.Predicate;

public final class Sieved<T>
implements Optional<T> {
    private final Predicate<T> mPredicate;
    private final Optional<T> mDelegate;

    public Sieved(Predicate<T> predicate, Optional<T> delegate) {
        this.mPredicate = predicate;
        this.mDelegate = delegate;
    }

    @Override
    public boolean isPresent() {
        return this.mDelegate.isPresent() && this.mPredicate.satisfiedBy(this.mDelegate.value());
    }

    @Override
    public T value() throws NoSuchElementException {
        T value = this.mDelegate.value();
        if (!this.mPredicate.satisfiedBy(value)) {
            throw new NoSuchElementException("Delegate sieved.");
        }
        return value;
    }
}

