/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.field;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.base.common.DroolsObjectInput;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.core.common.InternalWorkingMemory;

public class ClassFieldImpl
implements FieldValue,
Externalizable {
    private Class type;
    private String className;

    public ClassFieldImpl(Class value) {
        this.className = value.getName();
        this.type = value;
    }

    public ClassFieldImpl(String value) {
        this.className = value;
        try {
            this.type = Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public ClassFieldImpl() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.className);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = in.readUTF();
        try {
            this.type = in instanceof DroolsObjectInput ? Class.forName(this.className, false, ((DroolsObjectInput)in).getClassLoader()) : Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Object getValue() {
        return this.type;
    }

    public Object resolve(InternalWorkingMemory workingMemory) {
        try {
            this.type = workingMemory.getKnowledgeBase().getRootClassLoader().loadClass(this.className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.type;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ClassFieldImpl && this.className.equals(((ClassFieldImpl)obj).className);
    }

    public char getCharValue() {
        return '\u0000';
    }

    public BigDecimal getBigDecimalValue() {
        return null;
    }

    public BigInteger getBigIntegerValue() {
        return null;
    }

    public int getIntValue() {
        return 0;
    }

    public byte getByteValue() {
        return 0;
    }

    public short getShortValue() {
        return 0;
    }

    public long getLongValue() {
        return 0L;
    }

    public float getFloatValue() {
        return 0.0f;
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public boolean getBooleanValue() {
        return false;
    }

    public boolean isNull() {
        return this.className == null;
    }

    public boolean isBooleanField() {
        return false;
    }

    public boolean isIntegerNumberField() {
        return false;
    }

    public boolean isFloatNumberField() {
        return false;
    }

    public boolean isObjectField() {
        return true;
    }

    public boolean isCollectionField() {
        return false;
    }

    public boolean isStringField() {
        return false;
    }
}

