/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;

public abstract class Assert {
    private Description description;
    private String errorMessage;

    public final String description() {
        return Formatting.valueOf(this.description);
    }

    protected final void description(String d) {
        this.description(new BasicDescription(d));
    }

    protected final void description(Description d) {
        this.description = d;
    }

    protected final Description rawDescription() {
        return this.description;
    }

    protected final String formattedErrorMessage(String message) {
        return Formatting.format(this.description, message);
    }

    protected final void replaceDefaultErrorMessagesWith(String message) {
        this.errorMessage = message;
    }

    protected final String customErrorMessage() {
        return this.errorMessage;
    }

    protected final void failIfCustomMessageIsSet() {
        Fail.failWithMessage(this.customErrorMessage());
    }

    protected final void failIfCustomMessageIsSet(Throwable realCause) {
        Fail.failWithMessage(this.customErrorMessage(), realCause);
    }

    protected final void fail(String reason, Throwable cause) {
        Fail.fail(this.formattedErrorMessage(reason), cause);
    }

    protected final AssertionError fail(String reason) {
        throw this.failure(reason);
    }

    protected final AssertionError failure(String reason) {
        return Fail.failure(this.formattedErrorMessage(reason));
    }

    public final boolean equals(Object obj) {
        throw new UnsupportedOperationException("'equals' is not supported...maybe you intended to call 'isEqualTo'");
    }

    public final int hashCode() {
        return 1;
    }
}

