/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.fest.util.IntrospectionError;
import org.fest.util.Strings;

public final class Introspection {
    public static PropertyDescriptor descriptorForProperty(String propertyName, Object target) {
        Introspection.validate(propertyName, target);
        BeanInfo beanInfo = null;
        Class<?> type = target.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(type);
        }
        catch (Exception e) {
            throw new IntrospectionError(String.format("Unable to get BeanInfo for type %s", type.getName()), e);
        }
        for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(d.getName())) continue;
            return d;
        }
        throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage(propertyName, target));
    }

    private static String propertyNotFoundErrorMessage(String propertyName, Object target) {
        String targetTypeName = target.getClass().getName();
        String property = Strings.quote(propertyName);
        Method getter = Introspection.beanGetter(propertyName, target);
        if (getter == null) {
            return String.format("No getter for property %s in %s", property, targetTypeName);
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            return String.format("No public getter for property %s in %s", property, targetTypeName);
        }
        return String.format("Unable to find property %s in %s", property, targetTypeName);
    }

    private static Method beanGetter(String propertyName, Object target) {
        Introspection.validate(propertyName, target);
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter = Introspection.findMethod("get" + capitalized, target);
        if (getter != null) {
            return getter;
        }
        return Introspection.findMethod("is" + capitalized, target);
    }

    private static Method findMethod(String name, Object target) {
        try {
            return target.getClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void validate(String propertyName, Object target) {
        if (propertyName == null) {
            throw new NullPointerException("The property name should not be null");
        }
        if (Strings.isEmpty(propertyName)) {
            throw new IllegalArgumentException("The property name should not be empty");
        }
        if (target == null) {
            throw new NullPointerException("The target object should not be null");
        }
    }

    private Introspection() {
    }
}

