/*
 * Decompiled with CFR 0.152.
 */
package net.java.sezpoz;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sezpoz.impl.SerAnnConst;
import net.java.sezpoz.impl.SerAnnotatedElement;
import net.java.sezpoz.impl.SerEnumConst;
import net.java.sezpoz.impl.SerTypeConst;
import org.sonatype.guice.bean.reflect.ClassSpace;

public final class SpaceIndexItem<A extends Annotation, I> {
    private static final Logger LOGGER = Logger.getLogger(SpaceIndexItem.class.getName());
    private final SerAnnotatedElement structure;
    private final Class<A> annotationType;
    private final Class<I> instanceType;
    private final ClassSpace space;
    private final URL resource;
    private AnnotatedElement element;
    private Object instance;

    SpaceIndexItem(SerAnnotatedElement structure, Class<A> annotationType, Class<I> instanceType, ClassSpace space, URL resource) throws IOException {
        this.structure = structure;
        this.annotationType = annotationType;
        this.instanceType = instanceType;
        this.space = space;
        this.resource = resource;
        LOGGER.log(Level.FINE, "Loaded index item {0}", structure);
    }

    public A annotation() {
        return SpaceIndexItem.proxy(this.annotationType, this.structure.values);
    }

    public ElementType kind() {
        return this.structure.isMethod ? ElementType.METHOD : (this.structure.memberName != null ? ElementType.FIELD : ElementType.TYPE);
    }

    public String className() {
        return this.structure.className;
    }

    public String memberName() {
        return this.structure.memberName;
    }

    public AnnotatedElement element() throws InstantiationException {
        if (this.element == null) {
            try {
                Class impl = this.space.loadClass(this.className());
                this.element = this.structure.isMethod ? impl.getMethod(this.structure.memberName, new Class[0]) : (this.structure.memberName != null ? impl.getField(this.structure.memberName) : impl);
                LOGGER.log(Level.FINER, "Loaded annotated element: {0}", this.element);
            }
            catch (Exception x) {
                throw (InstantiationException)new InstantiationException(String.valueOf(SpaceIndexItem.labelFor(this.resource)) + " might need to be rebuilt: " + x).initCause(x);
            }
            catch (LinkageError x) {
                throw (InstantiationException)new InstantiationException(x.toString()).initCause(x);
            }
        }
        return this.element;
    }

    private static String labelFor(URL resource) {
        String u = resource.toString();
        Matcher m = Pattern.compile("jar:(file:.+)!/.+").matcher(u);
        if (m.matches()) {
            return new File(URI.create(m.group(1))).getAbsolutePath();
        }
        return u;
    }

    public I instance() throws InstantiationException {
        if (this.instance == null) {
            AnnotatedElement e = this.element();
            try {
                this.instance = e instanceof Class ? ((Class)e).newInstance() : (e instanceof Method ? ((Method)e).invoke(null, new Object[0]) : ((Field)e).get(null));
                LOGGER.log(Level.FINER, "Loaded instance: {0}", this.instance);
            }
            catch (InstantiationException x) {
                throw x;
            }
            catch (Exception x) {
                throw (InstantiationException)new InstantiationException(x.toString()).initCause(x);
            }
            catch (LinkageError x) {
                throw (InstantiationException)new InstantiationException(x.toString()).initCause(x);
            }
        }
        return this.instanceType.cast(this.instance);
    }

    public int hashCode() {
        return this.className().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpaceIndexItem)) {
            return false;
        }
        SpaceIndexItem o = (SpaceIndexItem)obj;
        return this.structure.equals((Object)o.structure) && this.annotationType == o.annotationType && this.space == o.space;
    }

    public String toString() {
        return "@" + this.annotationType.getName() + ":" + this.structure;
    }

    private static <T extends Annotation> T proxy(Class<T> type, Map<String, Object> data) {
        return (T)((Annotation)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new AnnotationProxy(type, data))));
    }

    private static final class AnnotationProxy
    implements InvocationHandler {
        private final Class<? extends Annotation> type;
        private final Map<String, Object> data;

        public AnnotationProxy(Class<? extends Annotation> type, Map<String, Object> data) {
            this.type = type;
            this.data = data;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if (name.equals("annotationType") && method.getParameterTypes().length == 0) {
                return this.type;
            }
            if (name.equals("hashCode") && method.getParameterTypes().length == 0) {
                int x = 0;
                Method[] methodArray = this.type.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    Object val = this.annCall(m);
                    int valhash = val.hashCode();
                    Class arrClazz = val instanceof Object[] ? Object[].class : val.getClass();
                    try {
                        Method arraysHashCode = Arrays.class.getMethod("hashCode", arrClazz);
                        valhash = (Integer)arraysHashCode.invoke(null, val);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    x += 127 * m.getName().hashCode() ^ valhash;
                    ++n2;
                }
                return x;
            }
            if (name.equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
                if (!(args[0] instanceof Annotation)) {
                    return false;
                }
                Annotation o = (Annotation)args[0];
                if (this.type != o.annotationType()) {
                    return false;
                }
                Method[] methodArray = this.type.getDeclaredMethods();
                int n = methodArray.length;
                int n3 = 0;
                while (n3 < n) {
                    block13: {
                        Method m = methodArray[n3];
                        Object myval = this.annCall(m);
                        Object other = m.invoke((Object)o, new Object[0]);
                        Class arrClazz = myval instanceof Object[] ? Object[].class : myval.getClass();
                        try {
                            Method arraysEquals = Arrays.class.getMethod("equals", arrClazz, arrClazz);
                            if (!((Boolean)arraysEquals.invoke(null, myval, other)).booleanValue()) {
                                return false;
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (myval.equals(other)) break block13;
                            return false;
                        }
                    }
                    ++n3;
                }
                return true;
            }
            if (name.equals("toString") && method.getParameterTypes().length == 0) {
                return "@" + this.type.getName() + this.data;
            }
            return this.annCall(method);
        }

        private Object annCall(Method m) throws Exception {
            assert (m.getParameterTypes().length == 0);
            String name = m.getName();
            if (this.data.containsKey(name)) {
                return this.evaluate(this.data.get(name), m.getReturnType());
            }
            Object o = m.getDefaultValue();
            assert (o != null);
            return o;
        }

        private Object evaluate(Object o, Class<?> expectedType) throws Exception {
            if (o instanceof SerAnnConst) {
                SerAnnConst a = (SerAnnConst)o;
                return SpaceIndexItem.proxy(this.type.getClassLoader().loadClass(a.name).asSubclass(Annotation.class), a.values);
            }
            if (o instanceof SerTypeConst) {
                return this.type.getClassLoader().loadClass(((SerTypeConst)o).name);
            }
            if (o instanceof SerEnumConst) {
                SerEnumConst e = (SerEnumConst)o;
                return this.type.getClassLoader().loadClass(e.enumName).getField(e.constName).get(null);
            }
            if (o instanceof ArrayList) {
                List l = (List)o;
                Class<?> compType = expectedType.getComponentType();
                int size = l.size();
                Object arr = Array.newInstance(compType, size);
                int i = 0;
                while (i < size) {
                    Array.set(arr, i, this.evaluate(l.get(i), compType));
                    ++i;
                }
                return arr;
            }
            return o;
        }
    }
}

