/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal;

import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.URLClassSpace;

public class ClassSpaceFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassSpaceFactory.class);

    public ClassSpace create(ClassLoader parent, URL ... urls) {
        return this.createClassSpace(parent, urls);
    }

    public ClassSpace create(ClassLoader parent, Class ... types) {
        return this.createClassSpace(parent, this.scanTypes(types));
    }

    private URL[] scanTypes(Class[] types) {
        assert (types != null);
        ArrayList<URL> path = new ArrayList<URL>();
        Class[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            path.add(type.getProtectionDomain().getCodeSource().getLocation());
            ++n2;
        }
        return path.toArray(new URL[path.size()]);
    }

    private ClassSpace createClassSpace(ClassLoader parent, URL[] urls) {
        if (log.isDebugEnabled()) {
            log.debug("Path:");
            URL[] uRLArray = urls;
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                log.debug("  {}", (Object)url);
                ++n2;
            }
        }
        return new URLClassSpace(parent, urls);
    }
}

