/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.Collection;

@XStreamAlias(value="oid")
public class OID {
    public static final OID NULL = new OID();
    @XStreamAsAttribute
    private final String type;
    @XStreamAsAttribute
    private final int hash;

    private OID(String type, int hash) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.hash = hash;
    }

    private OID() {
        this.type = null;
        this.hash = System.identityHashCode(this);
    }

    public String getType() {
        return this.type;
    }

    public int getHash() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OID)) {
            return false;
        }
        OID that = (OID)obj;
        if (this.hash != that.hash) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.hash;
        return result;
    }

    public String toString() {
        if (this == NULL) {
            return null;
        }
        return String.format("%s@%x", this.type, this.hash);
    }

    public static OID get(Object obj) {
        if (obj == null) {
            return NULL;
        }
        return new OID(obj.getClass().getName(), System.identityHashCode(obj));
    }

    public static OID parse(String spec) {
        assert (spec != null);
        String[] items = spec.split("@");
        if (items.length != 2) {
            throw new IllegalArgumentException();
        }
        return new OID(items[0], Integer.parseInt(items[1], 16));
    }

    public static String render(Object obj) {
        assert (obj != null);
        return OID.get(obj).toString();
    }

    public static <T> T find(Collection<T> items, String id) {
        assert (items != null);
        assert (id != null);
        for (T item : items) {
            if (!OID.render(item).equals(id)) continue;
            return item;
        }
        return null;
    }

    public static <T> T find(Collection<T> items, OID id) {
        assert (id != null);
        return OID.find(items, id.toString());
    }
}

