/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal.extension;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import hudson.Extension;
import hudson.ExtensionFinder;
import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.java.sezpoz.SpaceIndex;
import net.java.sezpoz.SpaceIndexItem;
import org.hudsonci.inject.internal.extension.ExtensionQualifierImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.guice.bean.reflect.ClassSpace;

public final class SezPozExtensionModule
implements Module {
    private static final Logger log = LoggerFactory.getLogger(SezPozExtensionModule.class);
    private final ClassSpace space;
    private final boolean globalIndex;

    public SezPozExtensionModule(ClassSpace space, boolean globalIndex) {
        this.space = (ClassSpace)Preconditions.checkNotNull((Object)space);
        this.globalIndex = globalIndex;
    }

    public void configure(Binder binder) {
        for (SpaceIndexItem<Extension, Object> spaceIndexItem : SpaceIndex.load(Extension.class, Object.class, this.space, this.globalIndex)) {
            try {
                if (ExtensionFinder.Sezpoz.class.equals((Object)spaceIndexItem.element())) continue;
                this.bindItem(binder, spaceIndexItem);
            }
            catch (Throwable e) {
                if (spaceIndexItem.annotation().optional()) {
                    log.debug("Failed to bind optional extension: {}", spaceIndexItem, (Object)e);
                    continue;
                }
                log.warn("Failed to bind extension: {}", spaceIndexItem, (Object)e);
            }
        }
    }

    private void bindItem(Binder binder, SpaceIndexItem<Extension, ?> item) throws InstantiationException {
        switch (item.kind()) {
            case TYPE: {
                Class impl = (Class)item.element();
                binder.bind(impl).in(Scopes.SINGLETON);
                SezPozExtensionModule.bindHierarchy(binder, Key.get((Class)impl));
                break;
            }
            case METHOD: {
                Method method = (Method)item.element();
                String name = String.valueOf(method.getDeclaringClass().getName()) + '.' + method.getName();
                ExtensionQualifierImpl qualifier = new ExtensionQualifierImpl(item.annotation(), name);
                this.bindProvider(binder, item, Key.get(method.getReturnType(), (Annotation)qualifier));
                break;
            }
            case FIELD: {
                Field field = (Field)item.element();
                String name = String.valueOf(field.getDeclaringClass().getName()) + '.' + field.getName();
                ExtensionQualifierImpl qualifier = new ExtensionQualifierImpl(item.annotation(), name);
                this.bindProvider(binder, item, Key.get(field.getType(), (Annotation)qualifier));
                break;
            }
        }
    }

    private void bindProvider(Binder binder, final SpaceIndexItem item, Key key) {
        binder.bind(key).toProvider(new Provider(){

            public Object get() {
                try {
                    return item.instance();
                }
                catch (InstantiationException e) {
                    throw new ProvisionException(e.toString(), (Throwable)e);
                }
            }
        }).in(Scopes.SINGLETON);
        SezPozExtensionModule.bindHierarchy(binder, key);
    }

    private static void bindHierarchy(Binder binder, Key rootKey) {
        Class root = rootKey.getTypeLiteral().getRawType();
        Annotation qualifier = rootKey.getAnnotation();
        if (qualifier == null) {
            qualifier = Names.named((String)root.getName());
        }
        Class clazz = root;
        while (clazz != Object.class) {
            if (clazz != root && ExtensionPoint.class.isAssignableFrom(clazz)) {
                binder.bind(clazz).annotatedWith(qualifier).to(rootKey);
            }
            if (Descriptor.class.isAssignableFrom(clazz)) {
                binder.bind(Descriptor.class).annotatedWith(qualifier).to(rootKey);
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                if (ExtensionPoint.class.isAssignableFrom(iface)) {
                    binder.bind(iface).annotatedWith(qualifier).to(rootKey);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }
}

