/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal.extension;

import hudson.Extension;
import hudson.ExtensionComponent;
import java.lang.annotation.Annotation;
import org.hudsonci.inject.Priority;
import org.hudsonci.inject.internal.extension.ExtensionQualifier;
import org.sonatype.inject.BeanEntry;

public class SmoothieComponent<T>
extends ExtensionComponent<T> {
    private final BeanEntry<Annotation, T> bean;
    private final T value;
    private final double priority;
    public static final double DEFAULT_PRIORITY = 0.0;

    public SmoothieComponent(BeanEntry<Annotation, T> bean) {
        super(null);
        this.bean = bean;
        this.value = bean.getValue();
        this.priority = SmoothieComponent.priorityOf(bean);
    }

    public BeanEntry<Annotation, T> getBean() {
        return this.bean;
    }

    public Class<?> getType() {
        return this.getBean().getImplementationClass();
    }

    public T getInstance() {
        return this.value;
    }

    public double getPriority() {
        return this.priority;
    }

    public double ordinal() {
        return this.getPriority();
    }

    public String toString() {
        return "SmoothieComponent{type=" + this.getType() + ", priority=" + this.getPriority() + ", bean=" + this.bean + '}';
    }

    public static boolean isOptional(BeanEntry<Annotation, ?> beanEntry) {
        Boolean isOptional;
        block3: {
            try {
                isOptional = SmoothieComponent.isOptional(beanEntry.getKey());
                if (isOptional != null || (isOptional = SmoothieComponent.isOptional(beanEntry.getImplementationClass())) != null || (isOptional = SmoothieComponent.isOptional(beanEntry.getValue())) != null) break block3;
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return isOptional;
    }

    public static Boolean isOptional(Object component) {
        if (component != null) {
            return SmoothieComponent.isOptional(component.getClass());
        }
        return null;
    }

    public static Boolean isOptional(Class<?> type) {
        if (type != null) {
            Extension extension = type.getAnnotation(Extension.class);
            if (extension != null) {
                return extension.optional();
            }
            ExtensionQualifier qualifier = type.getAnnotation(ExtensionQualifier.class);
            if (qualifier != null) {
                return qualifier.extension().optional();
            }
        }
        return null;
    }

    public static Boolean isOptional(Annotation annotation) {
        if (annotation != null) {
            if (annotation instanceof Extension) {
                return ((Extension)annotation).optional();
            }
            if (annotation instanceof ExtensionQualifier) {
                return ((ExtensionQualifier)annotation).extension().optional();
            }
        }
        return null;
    }

    public static double priorityOf(BeanEntry<Annotation, ?> beanEntry) {
        Double priority;
        block3: {
            try {
                priority = SmoothieComponent.priorityOf(beanEntry.getKey());
                if (priority != null || (priority = SmoothieComponent.priorityOf(beanEntry.getImplementationClass())) != null || (priority = SmoothieComponent.priorityOf(beanEntry.getValue())) != null) break block3;
                return 0.0;
            }
            catch (Throwable throwable) {
                return 0.0;
            }
        }
        return priority;
    }

    public static Double priorityOf(Object component) {
        if (component != null) {
            return SmoothieComponent.priorityOf(component.getClass());
        }
        return null;
    }

    public static Double priorityOf(Class<?> type) {
        if (type != null) {
            Extension extension = type.getAnnotation(Extension.class);
            if (extension != null) {
                return extension.ordinal();
            }
            ExtensionQualifier qualifier = type.getAnnotation(ExtensionQualifier.class);
            if (qualifier != null) {
                return qualifier.extension().ordinal();
            }
            Priority priority = type.getAnnotation(Priority.class);
            if (priority != null) {
                return priority.value();
            }
        }
        return null;
    }

    public static Double priorityOf(Annotation annotation) {
        if (annotation != null) {
            if (annotation instanceof Extension) {
                return ((Extension)annotation).ordinal();
            }
            if (annotation instanceof ExtensionQualifier) {
                return ((ExtensionQualifier)annotation).extension().ordinal();
            }
            if (annotation instanceof Priority) {
                return ((Priority)annotation).value();
            }
        }
        return null;
    }
}

