/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal.plugin;

import com.google.inject.Key;
import com.google.inject.name.Names;
import hudson.ExtensionComponent;
import hudson.PluginManager;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import hudson.model.Hudson;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.hudsonci.inject.Smoothie;
import org.hudsonci.inject.internal.HudsonModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingPluginStrategy
implements PluginStrategy {
    private static final Logger log = LoggerFactory.getLogger(DelegatingPluginStrategy.class);
    private final PluginStrategy delegate;

    public DelegatingPluginStrategy(PluginManager plugins) {
        HudsonModule.bind(plugins);
        this.delegate = (PluginStrategy)Smoothie.getContainer().get(Key.get(PluginStrategy.class, (Annotation)Names.named((String)"default")));
        log.debug("Delegate: {}", (Object)this.delegate);
    }

    public PluginStrategy getDelegate() {
        return this.delegate;
    }

    public PluginWrapper createPluginWrapper(File archive) throws IOException {
        return this.getDelegate().createPluginWrapper(archive);
    }

    public void load(PluginWrapper plugin) throws IOException {
        this.getDelegate().load(plugin);
    }

    public void initializeComponents(PluginWrapper plugin) {
        this.getDelegate().initializeComponents(plugin);
    }

    public <T> List<ExtensionComponent<T>> findComponents(Class<T> type, Hudson hudson) {
        return this.getDelegate().findComponents(type, hudson);
    }
}

