/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.inject.internal.plugin;

import com.google.common.base.Preconditions;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.Plugin;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import hudson.model.Hudson;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.inject.SmoothieContainer;
import org.hudsonci.inject.internal.extension.ExtensionLocator;
import org.hudsonci.inject.internal.plugin.PluginClassLoader;
import org.hudsonci.inject.internal.plugin.PluginWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default")
@Singleton
public class SmoothiePluginStrategy
implements PluginStrategy {
    private static final Logger log = LoggerFactory.getLogger(SmoothiePluginStrategy.class);
    private final SmoothieContainer container;
    private final PluginWrapperFactory pluginFactory;
    private final ExtensionLocator extensionLocator;
    private final List<ExtensionFinder> extensionFinders;

    @Inject
    public SmoothiePluginStrategy(SmoothieContainer container, PluginWrapperFactory pluginFactory, @Named(value="default") ExtensionLocator extensionLocator, List<ExtensionFinder> extensionFinders) {
        this.container = (SmoothieContainer)Preconditions.checkNotNull((Object)container);
        this.pluginFactory = (PluginWrapperFactory)Preconditions.checkNotNull((Object)pluginFactory);
        this.extensionLocator = (ExtensionLocator)Preconditions.checkNotNull((Object)extensionLocator);
        this.extensionFinders = (List)Preconditions.checkNotNull(extensionFinders);
    }

    private String basename(String name) {
        int i;
        assert (name != null);
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((i = name.lastIndexOf("/")) != -1) {
            return name.substring(i + 1, name.length());
        }
        return name;
    }

    public PluginWrapper createPluginWrapper(File archive) throws IOException {
        PluginWrapper plugin;
        Preconditions.checkNotNull((Object)archive);
        try {
            plugin = this.pluginFactory.create(archive);
        }
        catch (Exception e) {
            throw new IOException2((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            this.logPluginDetails(plugin);
        }
        return plugin;
    }

    private void logPluginDetails(PluginWrapper plugin) {
        List dependencies;
        assert (plugin != null);
        log.debug("Loaded plugin: {} ({})", (Object)plugin.getShortName(), (Object)plugin.getVersion());
        log.debug("  State: active={}, enabled={}, pinned={}, downgradable={}", new Object[]{plugin.isActive(), plugin.isEnabled(), plugin.isPinned(), plugin.isDowngradable()});
        PluginClassLoader cl = (PluginClassLoader)((Object)plugin.classLoader);
        URL[] classpath = cl.getURLs();
        if (classpath.length > 1) {
            log.debug("  Classpath:");
            int i = 0;
            boolean trace = log.isTraceEnabled();
            URL[] uRLArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                if (i++ != 0) {
                    log.debug("    {}", (Object)(trace ? url.toString() : this.basename(url.getFile())));
                }
                ++n2;
            }
        }
        if ((dependencies = plugin.getDependencies()) != null && !dependencies.isEmpty()) {
            log.debug("  Dependencies:");
            for (PluginWrapper.Dependency dependency : dependencies) {
                log.debug("    {}", (Object)dependency);
            }
        }
        if ((dependencies = plugin.getOptionalDependencies()) != null && !dependencies.isEmpty()) {
            log.debug("  Optional dependencies:");
            for (PluginWrapper.Dependency dependency : plugin.getOptionalDependencies()) {
                log.debug("    {}", (Object)dependency);
            }
        }
    }

    public void load(PluginWrapper plugin) throws IOException {
        Preconditions.checkNotNull((Object)plugin);
        if (log.isDebugEnabled()) {
            log.debug("Configuring plugin: {}", (Object)plugin.getShortName());
        }
        this.container.register(plugin);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(plugin.classLoader);
        try {
            Plugin.DummyImpl instance;
            if (plugin.getPluginClass() == null) {
                instance = new Plugin.DummyImpl();
            } else {
                try {
                    Class<? extends Plugin> type = this.loadPluginClass(plugin);
                    instance = (Plugin)this.container.injector(plugin).getInstance(type);
                    log.trace("Plugin instance: {}", (Object)instance);
                }
                catch (Throwable e) {
                    throw new IOException2("Failed to load plugin instance for: " + plugin.getShortName(), e);
                }
            }
            plugin.setPlugin((Plugin)instance);
            try {
                this.start(plugin);
            }
            catch (Exception e) {
                throw new IOException2("Failed to start plugin: " + plugin.getShortName(), (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private Class<? extends Plugin> loadPluginClass(PluginWrapper plugin) throws ClassNotFoundException {
        assert (plugin != null);
        return plugin.classLoader.loadClass(plugin.getPluginClass());
    }

    private void start(PluginWrapper plugin) throws Exception {
        assert (plugin != null);
        if (log.isDebugEnabled()) {
            log.debug("Starting plugin: {}", (Object)plugin.getShortName());
        }
        Plugin instance = plugin.getPlugin();
        instance.setServletContext(Hudson.getInstance().servletContext);
        instance.start();
    }

    public void initializeComponents(PluginWrapper plugin) {
        throw new Error("Unused operation");
    }

    /*
     * Unable to fully structure code
     */
    public <T> List<ExtensionComponent<T>> findComponents(Class<T> type, Hudson hudson) {
        components = this.extensionLocator.locate(type);
        block4: for (ExtensionFinder finder : this.extensionFinders) {
            try {
                try {
                    components.addAll(finder._find(type, hudson));
                    continue;
                }
                catch (AbstractMethodError v0) {
                    ** for (instance : finder.findExtensions(type, (Hudson)hudson))
                }
lbl-1000:
                // 1 sources

                {
                    components.add(new ExtensionComponent(instance));
                    continue;
lbl13:
                    // 1 sources

                }
            }
            catch (Throwable e) {
                SmoothiePluginStrategy.log.warn("Failed to query ExtensionFinder: " + finder, e);
            }
        }
        return components;
    }
}

