/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.event;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hudsonci.utils.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventHandlerSupport<ContextType, EventType>
implements EventHandler<ContextType, EventType> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ContextType context;
    private Class eventType;

    @Override
    public void init(ContextType context) {
        this.context = Preconditions.checkNotNull(context);
    }

    protected ContextType getContext() {
        return this.context;
    }

    @Override
    public boolean accept(Object event) {
        Preconditions.checkNotNull((Object)event);
        return this.getEventType().isAssignableFrom(event.getClass());
    }

    protected Class getEventType() {
        if (this.eventType == null) {
            for (Method method : this.getClass().getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE || !method.getName().equals("handle") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] == Object.class) continue;
                this.eventType = method.getParameterTypes()[0];
                this.log.debug("Determined type: {}, from method: {}", (Object)this.eventType.getName(), (Object)method);
                break;
            }
            if (this.eventType == null) {
                throw new Error(this.getClass().getName() + " missing 'public void handle(<?>)' method");
            }
        }
        return this.eventType;
    }
}

