/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;

public class DelegatingOutputStream
extends OutputStream {
    private OutputStream delegate;

    public DelegatingOutputStream(OutputStream delegate) {
        this.setDelegate(delegate);
    }

    protected OutputStream getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(OutputStream delegate) {
        this.delegate = (OutputStream)Preconditions.checkNotNull((Object)delegate);
    }

    @Override
    public void write(int b) throws IOException {
        this.getDelegate().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getDelegate().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getDelegate().write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.getDelegate().flush();
    }

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
    }
}

