/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;

public class OffsetLimitInputStream
extends InputStream {
    public static final int UNLIMITED = -1;
    private final InputStream delegate;
    private final long offset;
    private final long length;
    private long count = 0L;

    public OffsetLimitInputStream(InputStream delegate, long offset, long length) throws IOException {
        this.delegate = (InputStream)Preconditions.checkNotNull((Object)delegate);
        this.offset = offset;
        this.length = length;
        delegate.skip(offset);
    }

    public InputStream getDelegate() {
        return this.delegate;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        if (this.length > -1L && this.count > this.length) {
            return -1;
        }
        ++this.count;
        return this.getDelegate().read();
    }

    @Override
    public int available() throws IOException {
        return this.getDelegate().available();
    }

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.getDelegate().mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getDelegate().reset();
    }

    @Override
    public boolean markSupported() {
        return this.getDelegate().markSupported();
    }
}

