/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.marshal.xref;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.hudsonci.utils.id.OID;
import org.hudsonci.utils.io.Closer;
import org.hudsonci.utils.marshal.Marshaller;
import org.hudsonci.utils.marshal.xref.XReference;
import org.hudsonci.utils.marshal.xref.XReferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileXReferenceStore
implements XReferenceStore {
    protected static final Logger log = LoggerFactory.getLogger(FileXReferenceStore.class);
    protected final Marshaller marshaller;
    protected final File root;

    public FileXReferenceStore(Marshaller marshaller, File root) {
        this.marshaller = (Marshaller)Preconditions.checkNotNull((Object)marshaller);
        this.root = root;
    }

    public FileXReferenceStore(Marshaller marshaller) {
        this(marshaller, null);
    }

    public File getRoot() {
        return this.root;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    protected void mkdirs(File file) {
        assert (file != null);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                log.warn("Failed to create directory: " + dir);
            } else {
                log.debug("Created directory: {}", (Object)dir);
            }
        } else if (dir.isFile()) {
            log.warn("Expected directory; found file: {}", (Object)dir);
        }
    }

    protected String sanitize(String path) {
        assert (path != null);
        return path.replaceAll("\\$", "_-");
    }

    protected File getFile(XReference ref) {
        assert (ref != null);
        String path = this.sanitize(ref.getPath());
        File dir = this.getRoot();
        return dir != null ? new File(dir, path) : new File(path);
    }

    protected Marshaller getMarshaller(XReference ref) {
        Marshaller m = ref.getMarshaller();
        if (m == null) {
            m = this.marshaller;
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(XReference ref) throws IOException {
        assert (ref != null);
        Marshaller marshaller = this.getMarshaller(ref);
        File file = this.getFile(ref);
        this.mkdirs(file);
        if (log.isTraceEnabled()) {
            log.trace("Marshalling reference: {} to file: {}", (Object)OID.get(ref), (Object)file);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            marshaller.marshal(ref.get(), writer);
        }
        catch (Throwable throwable) {
            Closer.close(writer);
            throw throwable;
        }
        Closer.close(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(XReference ref) throws IOException {
        Object value;
        assert (ref != null);
        Marshaller marshaller = this.getMarshaller(ref);
        File file = this.getFile(ref);
        if (log.isTraceEnabled()) {
            log.trace("Unmarshalling reference: {} from file: {}", (Object)OID.get(ref), (Object)file);
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            value = marshaller.unmarshal(reader);
        }
        catch (Throwable throwable) {
            Closer.close(reader);
            throw throwable;
        }
        Closer.close(reader);
        return value;
    }
}

