/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.marshal.xref;

import com.google.common.base.Preconditions;
import org.hudsonci.utils.marshal.Marshaller;

public abstract class XReference<T> {
    protected transient Holder<T> holder;

    public XReference(T value) {
        this.set(value);
    }

    public XReference() {
    }

    public void set(T value) {
        if (value != null) {
            this.holder = new InstanceHolder<T>(value);
        }
    }

    public T get() {
        if (this.holder != null) {
            return this.holder.get();
        }
        return null;
    }

    public abstract String getPath();

    public Marshaller getMarshaller() {
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "{" + "holder=" + this.holder + '}';
    }

    public static class InstanceHolder<T>
    implements Holder<T> {
        protected final T instance;

        protected InstanceHolder(T instance) {
            this.instance = Preconditions.checkNotNull(instance);
        }

        @Override
        public T get() {
            return this.instance;
        }

        public String toString() {
            return "InstanceHolder{instance=" + this.instance + '}';
        }
    }

    public static interface Holder<T> {
        public T get();
    }
}

