/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.rewrite.handler.Rule;

public abstract class RegexRule
extends Rule {
    private Pattern _regex;

    public RegexRule() {
    }

    public RegexRule(String pattern) {
        this.setRegex(pattern);
    }

    public String getRegex() {
        return this._regex == null ? null : this._regex.pattern();
    }

    public void setRegex(String regex) {
        this._regex = regex == null ? null : Pattern.compile(regex);
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        String target = input.getHttpURI().getPathQuery();
        Matcher matcher = this._regex.matcher(target);
        if (matcher.matches()) {
            return this.apply(input, matcher);
        }
        return null;
    }

    protected abstract Rule.Handler apply(Rule.Handler var1, Matcher var2) throws IOException;

    @Override
    public String toString() {
        return "%s[regex:%s]".formatted(super.toString(), this.getRegex());
    }
}

