/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.websocket.core.api.UpgradeException;
import org.eclipse.jetty.websocket.core.api.UpgradeResponse;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class ClientUpgradeResponse
implements UpgradeResponse {
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private int statusCode;
    private String statusReason;
    private MultiMap<String> headers = new MultiMap();
    private List<ExtensionConfig> extensions;
    private boolean success = false;

    public void addHeader(String name, String value) {
        this.headers.add(name.toLowerCase(Locale.ENGLISH), (Object)value);
    }

    public String getAcceptedSubProtocol() {
        return (String)this.headers.getValue(SEC_WEBSOCKET_PROTOCOL, 0);
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Set<String> getHeaderNamesSet() {
        return this.headers.keySet();
    }

    public String getHeaderValue(String name) {
        return (String)this.headers.getValue(name.toLowerCase(Locale.ENGLISH), 0);
    }

    public Iterator<String> getHeaderValues(String name) {
        List values = this.headers.getValues(name.toLowerCase(Locale.ENGLISH));
        if (values == null) {
            return Collections.emptyIterator();
        }
        return values.iterator();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void sendForbidden(String message) throws IOException {
        throw new UnsupportedOperationException("Not supported on client implementation");
    }

    public void setAcceptedSubProtocol(String protocol) {
        this.headers.put(SEC_WEBSOCKET_PROTOCOL, (Object)protocol);
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<ExtensionConfig>();
        } else {
            this.extensions.clear();
        }
        this.extensions.addAll(extensions);
    }

    public void setHeader(String name, String value) {
        this.headers.putValues(name, (Object[])new String[]{value});
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public void validateWebSocketHash(String expectedHash) throws UpgradeException {
        String respHash = this.getHeaderValue("Sec-WebSocket-Accept");
        this.success = true;
        if (!expectedHash.equals(respHash)) {
            this.success = false;
            throw new UpgradeException("Invalid Sec-WebSocket-Accept hash");
        }
    }
}

