/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.server.LargeFileRepository;
import org.eclipse.jgit.lfs.server.LfsObject;
import org.eclipse.jgit.lfs.server.TransferHandler;

public abstract class LfsProtocolServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONTENTTYPE_VND_GIT_LFS_JSON = "application/vnd.git-lfs+json";
    private Gson gson = LfsProtocolServlet.createGson();

    protected abstract LargeFileRepository getLargeFileRepository();

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.setContentType(CONTENTTYPE_VND_GIT_LFS_JSON);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), StandardCharsets.UTF_8));
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), StandardCharsets.UTF_8));
        LfsRequest request = (LfsRequest)this.gson.fromJson((Reader)r, LfsRequest.class);
        LargeFileRepository repo = this.getLargeFileRepository();
        if (repo == null) {
            res.setStatus(503);
            return;
        }
        TransferHandler handler = TransferHandler.forOperation(request.operation, repo, request.objects);
        this.gson.toJson((Object)handler.process(), (Appendable)w);
        ((Writer)w).flush();
    }

    private static Gson createGson() {
        GsonBuilder gb = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().disableHtmlEscaping();
        return gb.create();
    }

    private static class LfsRequest {
        String operation;
        List<LfsObject> objects;

        private LfsRequest() {
        }
    }
}

