/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.fs;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.WriteListener;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.errors.InvalidLongObjectIdException;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.lfs.server.fs.FileLfsRepository;
import org.eclipse.jgit.lfs.server.fs.ObjectDownloadListener;
import org.eclipse.jgit.lfs.server.fs.ObjectUploadListener;
import org.eclipse.jgit.lfs.server.internal.LfsServerText;

@WebServlet(asyncSupported=true)
public class FileLfsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final FileLfsRepository repository;
    private final long timeout;

    public FileLfsServlet(FileLfsRepository repository, long timeout) {
        this.repository = repository;
        this.timeout = timeout;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        AnyLongObjectId obj = this.getObjectToTransfer(req, rsp);
        if (obj != null) {
            if (this.repository.getSize(obj) == -1L) {
                FileLfsServlet.sendError(rsp, 404, MessageFormat.format(LfsServerText.get().objectNotFound, obj));
                return;
            }
            AsyncContext context = req.startAsync();
            context.setTimeout(this.timeout);
            rsp.getOutputStream().setWriteListener((WriteListener)new ObjectDownloadListener(this.repository, context, rsp, obj));
        }
    }

    private AnyLongObjectId getObjectToTransfer(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String info = req.getPathInfo();
        if (info.length() != 65) {
            FileLfsServlet.sendError(rsp, 400, MessageFormat.format(LfsServerText.get().invalidPathInfo, info));
            return null;
        }
        try {
            return LongObjectId.fromString((String)info.substring(1, 65));
        }
        catch (InvalidLongObjectIdException e) {
            FileLfsServlet.sendError(rsp, 400, e.getMessage());
            return null;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        AnyLongObjectId id = this.getObjectToTransfer(req, rsp);
        if (id != null) {
            AsyncContext context = req.startAsync();
            context.setTimeout(this.timeout);
            req.getInputStream().setReadListener((ReadListener)new ObjectUploadListener(this.repository, context, req, rsp, id));
        }
    }

    static void sendError(HttpServletResponse rsp, int status, String message) throws IOException {
        rsp.setStatus(status);
        rsp.flushBuffer();
    }
}

