/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.errors.CorruptLongObjectException;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.Constants;
import org.eclipse.jgit.lfs.server.fs.AtomicObjectOutputStream;
import org.eclipse.jgit.lfs.server.fs.FileLfsRepository;
import org.eclipse.jgit.lfs.server.fs.FileLfsServlet;

class ObjectUploadListener
implements ReadListener {
    private static Logger LOG = Logger.getLogger(ObjectUploadListener.class.getName());
    private final AsyncContext context;
    private final HttpServletResponse response;
    private final ServletInputStream in;
    private final ReadableByteChannel inChannel;
    private final AtomicObjectOutputStream out;
    private WritableByteChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(8192);

    public ObjectUploadListener(FileLfsRepository repository, AsyncContext context, HttpServletRequest request, HttpServletResponse response, AnyLongObjectId id) throws FileNotFoundException, IOException {
        this.context = context;
        this.response = response;
        this.in = request.getInputStream();
        this.inChannel = Channels.newChannel((InputStream)this.in);
        this.out = repository.getOutputStream(id);
        this.channel = Channels.newChannel(this.out);
        response.setContentType(Constants.CONTENT_TYPE_GIT_LFS_JSON);
    }

    public void onDataAvailable() throws IOException {
        while (this.in.isReady()) {
            if (this.inChannel.read(this.buffer) > 0) {
                this.buffer.flip();
                this.channel.write(this.buffer);
                this.buffer.compact();
                continue;
            }
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                this.channel.write(this.buffer);
            }
            this.close();
            return;
        }
    }

    public void onAllDataRead() throws IOException {
        this.close();
    }

    protected void close() throws IOException {
        try {
            this.inChannel.close();
            this.channel.close();
            this.response.setStatus(200);
        }
        finally {
            this.context.complete();
        }
    }

    public void onError(Throwable e) {
        try {
            int status;
            this.out.abort();
            this.inChannel.close();
            this.channel.close();
            if (e instanceof CorruptLongObjectException) {
                status = 400;
                LOG.log(Level.WARNING, e.getMessage(), e);
            } else {
                status = 500;
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            FileLfsServlet.sendError(this.response, status, e.getMessage());
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

