/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConvertMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;

public class EmbeddedAccessor
extends MappingAccessor {
    private List<ConvertMetadata> m_converts;
    private List<AssociationOverrideMetadata> m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
    private List<AttributeOverrideMetadata> m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();

    public EmbeddedAccessor() {
        super("<embedded>");
    }

    protected EmbeddedAccessor(String xmlElement) {
        super(xmlElement);
    }

    public EmbeddedAccessor(MetadataAnnotation embedded, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(embedded, accessibleObject, classAccessor);
        int n;
        int n2;
        Object[] objectArray;
        if (this.isAnnotationPresent("javax.persistence.AttributeOverrides")) {
            objectArray = this.getAnnotation("javax.persistence.AttributeOverrides").getAttributeArray("value");
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object attributeOverride = objectArray[n];
                this.m_attributeOverrides.add(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride, this));
                ++n;
            }
        }
        if (this.isAnnotationPresent("javax.persistence.AttributeOverride")) {
            this.m_attributeOverrides.add(new AttributeOverrideMetadata(this.getAnnotation("javax.persistence.AttributeOverride"), this));
        }
        if (this.isAnnotationPresent("javax.persistence.AssociationOverrides")) {
            objectArray = this.getAnnotation("javax.persistence.AssociationOverrides").getAttributeArray("value");
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object associationOverride = objectArray[n];
                this.m_associationOverrides.add(new AssociationOverrideMetadata((MetadataAnnotation)associationOverride, this));
                ++n;
            }
        }
        if (this.isAnnotationPresent("javax.persistence.AssociationOverride")) {
            this.m_associationOverrides.add(new AssociationOverrideMetadata(this.getAnnotation("javax.persistence.AssociationOverride"), this));
        }
    }

    @Override
    protected void addConvert(ConvertMetadata convert) {
        if (this.m_converts == null) {
            this.m_converts = new ArrayList<ConvertMetadata>();
        }
        this.m_converts.add(convert);
    }

    public void addMapsIdAccessor(MappingAccessor mapsIdAccessor) {
        ((AggregateObjectMapping)this.getMapping()).addMapsIdMapping(mapsIdAccessor.getMapping());
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof EmbeddedAccessor) {
            EmbeddedAccessor embeddedAccessor = (EmbeddedAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_associationOverrides, embeddedAccessor.getAssociationOverrides())) {
                return false;
            }
            if (!this.valuesMatch(this.m_attributeOverrides, embeddedAccessor.getAttributeOverrides())) {
                return false;
            }
            return this.valuesMatch(this.m_converts, embeddedAccessor.getConverts());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_converts != null ? this.m_converts.hashCode() : 0);
        result = 31 * result + (this.m_associationOverrides != null ? this.m_associationOverrides.hashCode() : 0);
        result = 31 * result + (this.m_attributeOverrides != null ? this.m_attributeOverrides.hashCode() : 0);
        return result;
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public List<ConvertMetadata> getConverts() {
        return this.m_converts;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_attributeOverrides, accessibleObject);
        this.initXMLObjects(this.m_associationOverrides, accessibleObject);
        this.initXMLObjects(this.m_converts, accessibleObject);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public void process() {
        AggregateMapping mapping = this.getOwningDescriptor().getClassDescriptor().newAggregateMapping();
        this.setMapping(mapping);
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(mapping);
        if (mapping.isAggregateObjectMapping()) {
            AggregateObjectMapping aggregateMapping = (AggregateObjectMapping)mapping;
            aggregateMapping.setIsNullAllowed(true);
            this.processAttributeOverrides(this.m_attributeOverrides, aggregateMapping, this.getReferenceDescriptor());
            this.processAssociationOverrides(this.m_associationOverrides, aggregateMapping, this.getReferenceDescriptor());
            this.processConverts(this.getConverts(this.m_converts), aggregateMapping, this.getReferenceClass(), false);
        } else if (mapping.isAbstractCompositeObjectMapping()) {
            ((AbstractCompositeObjectMapping)mapping).setField(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column"));
        }
        this.processReturnInsertAndUpdate();
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    public void setConverts(List<ConvertMetadata> converts) {
        this.m_converts = converts;
    }

    protected void updateDerivedIdField(EmbeddableMapping embeddableMapping, String overrideName, DatabaseField overrideField, MappingAccessor mappingAccessor) {
        this.addFieldNameTranslation(embeddableMapping, overrideName, overrideField, mappingAccessor);
        this.updatePrimaryKeyField(mappingAccessor, overrideField);
    }
}

